% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_across_datasets.R
\name{id_across_datasets}
\alias{id_across_datasets}
\title{ID across datasets}
\usage{
id_across_datasets(
  dt_list = NULL,
  id_col_name = "id",
  id_col_position = "first",
  silent = FALSE
)
}
\arguments{
\item{dt_list}{a list of data.table objects}

\item{id_col_name}{name of the column that will contain ID values}

\item{id_col_position}{position of the newly created ID column.
If \code{id_col_position = "first"}, the new ID column will
be placed as the first column in respective data sets.
If \code{id_col_position = "last"}, the new ID column will
be placed as the last column in respective data sets.}

\item{silent}{If \code{silent = TRUE}, a summary of starting and
ending ID values in each data set will not be printed.
If \code{silent = FALSE}, a summary of starting and
ending ID values in each data set will be printed. (default = FALSE)}
}
\value{
the output will be a list of data.table objects.
}
\description{
Create an ID column in each of the data sets. The ID values will
span across the data sets.
}
\examples{
# running the examples below requires importing the data.table package.
prep(data.table)
id_across_datasets(
dt_list = list(setDT(copy(mtcars)), setDT(copy(iris))))
id_across_datasets(
dt_list = list(setDT(copy(mtcars)), setDT(copy(iris)), setDT(copy(women))),
id_col_name = "newly_created_id_col",
id_col_position = "last")
}
