% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{easyLASSO}
\alias{easyLASSO}
\title{Select and fit sparse linear model with LASSO}
\usage{
easyLASSO(X, y, criterion = "lambda.1se")
}
\arguments{
\item{X}{Predictor matrix, nXp, with n observations and p
features.}

\item{y}{Response vector, or column or row matrix.  Must
have length n.}

\item{criterion}{String describing which lambda criterion to
use in selecting a LASSO model.  Choices
currently are c("lambda.1se","lambda.min").}
}
\value{
a glmnet model
}
\description{
The purpose of this function is to make the process
             of LASSO modelling as simple as possible.

             This is a simple wrapper on two glmnet functions
             which, when given input matrix X and response vector
             y, and a criterion for model selection, will
             estimate the lambda parameter, and return the
             LASSO results as a glmnet model.  This model
             can then be used to find coefficients and predictions.
}
\examples{
set.seed(1)
nObs <- 100
X <- distMat(nObs,6)
A <- cbind(c(1,0,-1,rep(0,3)))
  # Y will only depend on X[,1] and X[,3]
Y <- X \%*\% A + 0.1*rnorm(nObs)
lassoObj <- easyLASSO(X=X,y=Y) # LASSO fitting
Yhat <- predict(lassoObj,newx=X)
yyHatPlot(Y,Yhat)
coef( lassoObj ) # Sparse coefficients
coefPlot( lassoObj )
}
\seealso{
\code{\link[glmnet]{glmnet}} and
         \code{\link[glmnet]{cv.glmnet}}
}

