% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{coefPlot}
\alias{coefPlot}
\title{Plots coefficients in an impulse response format}
\usage{
coefPlot(xObj, includeIntercept = FALSE, type = "h", main = NULL, ...)
}
\arguments{
\item{xObj}{Output of a fitting model.}

\item{includeIntercept}{Should the 1st coefficient be plotted?
Default is FALSE.}

\item{type}{Graphics type.  Default is "h", which
results in an impulse-like plot.}

\item{main}{"main" title; default is the relative
number of non-zero coefficients,
a measure of sparsity.}

\item{...}{Optional additional graphical parameters,
for instance to set ylim to a fixed value.}
}
\value{
Invisibly returns TRUE.  Used for its
        graphic side effects only.
}
\description{
Given a model xObj for which coef(xObj)
    returns a set of coefficients, plot the coefficients.

    The plots make it easier to compare which features are large,
    which are set to zero, and how features change from run
    to run in a graphical manner.

    If the fitting process is linear (e.g. lm, glmnet, etc.)
    and the original features are appropriately ordered lags,
    this will generate an impulse response.

    Any coefficients that are \emph{exactly} zero (for instance,
    set that way by LASSO) will appear as red X's; non-zero
    points will be black O's.
}
\details{
If includeIntercept==TRUE, the intercept of the model
         will be plotted as index 0.

         Changing the type using \code{type="b"}
         will result in a parallel coordinate-like plot rather
         than an impulse-like plot.  It is sometimes easier to
         see the differences in coefficients with type="b"
         rather than type="h".
}
\examples{
set.seed(1)
nObs <- 100
X <- distMat(nObs,6)
A <- cbind(c(1,0,-1,rep(0,3))) # Y will only depend on X[,1] and X[,3]
Y <- X \%*\% A + 0.1*rnorm(nObs)
lassoObj <- easyLASSO(X,Y)
Yhat <- predict(lassoObj,newx=X)
yyHatPlot(Y,Yhat)
coef( lassoObj ) # Sparse coefficients
coefPlot( lassoObj )
coefPlot( lassoObj, includeIntercept=TRUE )
coefPlot( lassoObj, type="b" )
}

