% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{CSR}
\alias{CSR}
\title{Conditional Selection Rate}
\usage{
CSR(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A list of Joint Selection Rate matrices for each item pair.
}
\description{
Calculate the Conditional Selection Rate (CSR) for polytomous data.
CSR measures the proportion of respondents who selected a specific category
in item K, given that they selected a particular category in item J.
}
\details{
The function returns a nested list structure CSR, where \code{CSR[[j]][[k]]} contains
a matrix of conditional probabilities. In this matrix, the element at row l and
column m represents P(K=m|J=l), which is the probability of selecting category m
for item K, given that category l was selected for item J.

Mathematically, for each cell (l,m) in the \code{CSR[[j]][[k]]} matrix:
\code{CSR[[j]][[k]][l,m] = P(Item K = category m | Item J = category l)}

This is calculated as the number of respondents who selected both category l for
item J and category m for item K, divided by the total number of respondents who
selected category l for item J.
}
\examples{
# example code
# Calculate CSR using sample dataset J5S1000
CSR(J5S1000)

# Extract the conditional selection rates from item 1 to item 2
csr_1_2 <- CSR(J5S1000)[[1]][[2]]
# This shows the probability of selecting each category in item 2
# given that a specific category was selected in item 1
}
