% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCRBD.R
\name{fitCRBD}
\alias{fitCRBD}
\title{Fit a constant-rate birth-death process to a phylogeny}
\usage{
fitCRBD(phy, n.opt = 5, l.min = 0.001, l.max = 5, max.bad = 200)
}
\arguments{
\item{phy}{A \code{phylo} object, following terminology from package
\code{ape}, in which function will operate.}

\item{n.opt}{Number of optimizations that will be tried by function.}

\item{l.min}{Lower bound for optimization. Default value is \code{0.001}.}

\item{l.max}{Upper bound for optimization. Default value is \code{5}.}

\item{max.bad}{Maximum number of unsuccessful optimization attempts. Default
value is \code{200}.}
}
\value{
A \code{numeric} with the best estimates of speciation \code{S}
and extinction \code{E} rates.
}
\description{
\code{fitCRBD} fits a constant-rate birth-death process to a phylogeny in the
format of \code{ape} package's \code{phylo} object. Optimization is based on
likelihood functions made with \code{diversitree}. This function is
basically a wrapper for the \code{diversitree}'s \code{make.bd} function.
}
\examples{

S <- 0.1
E <- 0.1
set.seed(1)
phy <- simulateTree(pars = c(S, E), max.taxa = 30, max.t = 8)
fitCRBD(phy)

}
\references{
Paradis, E. (2012). Analysis of Phylogenetics and Evolution with R (Vol. 2).
New York: Springer.

Popescu, A. A., Huber, K. T., & Paradis, E. (2012). ape 3.0: New tools for
distance-based phylogenetics and evolutionary analysis in R. Bioinformatics,
28(11), 1536-1537.

FitzJohn, R. G. (2010). Analysing diversification with diversitree.
R Package. ver, 9-2.

FitzJohn, R. G. (2012). Diversitree: comparative phylogenetic analyses of
diversification in R. Methods in Ecology and Evolution, 3(6), 1084-1092.
}
\seealso{
see help page from \code{diversitree::make.bd} and
\code{stats::optim}
}
\author{
Daniel Rabosky, Matheus Januario, Jennifer Auler
}
