% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dinos_fossil}
\alias{dinos_fossil}
\title{Occurrence of dinosaur fossils}
\format{
A \code{data.frame} containing 15527 rows and 13 columns
\describe{
\item{phylum}{Organism phylum}
\item{class}{Organism taxonomic class}
\item{order}{Organism taxonomic order}
\item{family}{Organism taxonomic family}
\item{genus}{Organism genus}
\item{species}{Organism specific name}
\item{early_interval}{Earlier known geological period of occurrence}
\item{late_interval}{Later known geological period of occurrence}
\item{max_ma}{Occurrence's oldest time boundary in million years}
\item{min_ma}{Occurrence's newest time boundary in million years}
\item{midpoint}{Midpoint between max_ma and min_ma}
\item{lng}{Longitude of place where occurrence was found. Follows decimal degree format.}
\item{lat}{Latitude of place where occurrence was found. Follows decimal degree format.}
}
}
\source{
The Paleobiology Database (downloaded on 2022-03-11). \cr
Data URL: http://paleobiodb.org/data1.2/occs/list.csv?datainfo&rowcount&base_name=Dinosauria&show=full,classext,genus,subgenus,acconly,ident,img,etbasis,strat,lith,env,timebins,timecompare,resgroup,ref,ent,entname,crmod \cr
}
\usage{
dinos_fossil
}
\description{
Many dinosaur (including avian species) fossil occurrences from different
moments of the geological past. Much information (i.e., extra columns) was
removed from the original dataset to make it more compact, but it can be
fully accessed by the data URL. This dataset is part of the package and is
licensed under the Creative Commons Attribution 4.0 International License
(CC BY 4.0).
}
\keyword{datasets}
