% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R
\name{moments}
\alias{moments}
\alias{mean}
\alias{median}
\alias{mode}
\alias{var}
\alias{sd}
\alias{skew}
\alias{kurt}
\alias{entro}
\alias{finf}
\title{Moments - Parametric Quantities of Interest}
\usage{
moments(x)

mean(x, ...)

median(x, na.rm = FALSE, ...)

mode(x)

var(x, y = NULL, na.rm = FALSE, use)

sd(x, na.rm = FALSE)

skew(x, ...)

kurt(x, ...)

entro(x, ...)

finf(x, ...)
}
\arguments{
\item{x}{an object of a \code{Distribution} subclass.}

\item{...}{extra arguments.}

\item{y, use, na.rm}{arguments in \code{mean} and \code{var} standard methods from the
\code{stats} package not used here.}
}
\value{
Numeric, either vector or matrix depending on the moment and the
distribution. Function \code{moments()} returns a list of all available methods.
}
\description{
A set of functions that calculate the theoretical moments
(expectation, variance, skewness, excess kurtosis) and other important
parametric functions (median, mode, entropy, Fisher information) of a
distribution.
}
\details{
The \code{moments()} function automatically finds the available methods for a
given distribution and results all of the results in a list.

Not all functions are available for distributions; for example, the \code{sd()}
is available only for univariate distributions.
}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

library(estimators)

# Create the distribution
x <- Beta(3, 5)

# List of all available moments
mom <- moments(x)

# Expectation
mean(x)
mom$mean

# Variance and Standard Deviation
var(x)
sd(x)

# Skewness and Excess Kurtosis
skew(x)
kurt(x)

# Entropy
entro(x)

# Fisher Information Matrix
finf(x)
}
