% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{ergmito_gof}
\alias{ergmito_gof}
\alias{gof_ergmito}
\alias{plot.ergmito_gof}
\title{Goodness of Fit diagnostics for ERGMito models}
\usage{
gof_ergmito(
  object,
  GOF = NULL,
  GOF_update = NULL,
  probs = c(0.05, 0.95),
  sim_ci = FALSE,
  R = 50000L,
  ncores = 1L,
  ...
)

\method{plot}{ergmito_gof}(
  x,
  y = NULL,
  main = NULL,
  sub = NULL,
  tnames = NULL,
  sort_by_ci = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \link{ergmito}.}

\item{GOF}{Formula. Additional set of parameters to perform the GOF.}

\item{GOF_update}{Formula. See the section on model updating in \code{\link[=ergmito_formulae]{ergmito_formulae()}}.}

\item{probs}{Numeric vector. Quantiles to plot (see details).}

\item{sim_ci}{Logical scalar. If \code{FALSE}, the default, it will compute the
quantiles analytically, otherwise it samples from the ERGM distribution.}

\item{R}{Integer scalar. Number of simulations to generate (passed to \link{sample}).
This is only used if \code{sim_ci = TRUE}.}

\item{ncores}{Integer scalar. Number of cores to use for parallel computations
(currently ignored).}

\item{...}{Further arguments passed to \link[stats:quantile]{stats::quantile}.}

\item{x}{An object of class \code{ergmito_gof}.}

\item{y}{Ignored.}

\item{main, sub}{Title and subtitle of the plot (see \link[graphics:title]{graphics::title}).}

\item{tnames}{A named character vector. Alternative names for the terms.}

\item{sort_by_ci}{Logical scalar. When \code{TRUE} it will sort the x-axis by the
with of the CI in for the first parameter of the model.}
}
\value{
An object of class \code{ergmito_gof}. This is a list with the following
components:
\itemize{
\item \code{ci} A list of matrices of length \code{nnets(object)} with the corresponding
confidence intervals for the statistics of the model.
\item \code{target_stats} A matrix of the target statistics.
\item \code{ergmito.probs} A list of numeric vectors of length \code{nnets(object)} with the
probabilities associated to each possible structure of network.
\item \code{probs} The value passed via \code{probs}.
\item \code{model} The fitted model.
\item \code{term_names} Character vector. Names of the terms used in the model.
\item \code{quantile.args} A list of the values passed via \code{...}.
}
}
\description{
Goodness of Fit diagnostics for ERGMito models
}
\details{
The Goodness of Fit function uses the fitted ERGMito to calculate a given confidence
interval for a set of sufficient statistics. By default (and currently the
only available option), this is done on the sufficient statistics specified
in the model.

In detail, the algorithm is executed as follow:

For every network in the list of networks do:
\enumerate{
\item Calculate the probability of observing each possible graph in its support
using the fitted model.
\item If \code{sim_ci = TRUE}, draw \code{R} samples from each set of parameters using the
probabilities computed. Then using the \code{quantile} function, calculate the desired
quantiles of the sufficient statistics. Otherwise, compute the quantiles using
the analytic quantiles using the full distribution.'
}

The plot method is particularly convenient since it graphically shows whether
the target statistics of the model (observed statistics) fall within the
simulated range.

The print method tries to copy (explicitly) the print method of the
\code{gof} function from the \code{ergm} R package.
}
\examples{
# Fitting the fivenets model
data(fivenets, package = "ergmito")
fit <- ergmito(fivenets ~ edges + nodematch("female"))

# Calculating the gof
ans <- gof_ergmito(fit)

# Looking at the results
ans
plot(ans)
}
