% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_stats.R
\name{count_stats}
\alias{count_stats}
\alias{AVAILABLE_STATS}
\alias{count_stats.formula}
\alias{count_stats.list}
\title{Count Network Statistics}
\usage{
count_stats(X, ...)

AVAILABLE_STATS()

\method{count_stats}{formula}(X, ...)

\method{count_stats}{list}(X, terms, attrs = NULL, ...)
}
\arguments{
\item{X}{List of square matrices. (networks)}

\item{...}{Passed to the method.}

\item{terms}{Character vector with the names of the statistics to calculate.
Currently, the only available statistics are: '\Sexpr{paste(ergmito::AVAILABLE_STATS(), collapse="', '")}'.}

\item{attrs}{A list of vectors. This is used when \code{term} has a nodal attribute
such as \code{nodeicov(attrname="")}.}
}
\value{
A matrix of size \code{length(X) * length(terms)} with the corresponding
counts of statistics.
}
\description{
This function is similar to what \link[ergm:summary_formula]{ergm::summary_formula} does, but it provides
a fast wrapper suited for matrix class objects (see benchmark in the examples).
}
\examples{
# DGP 
set.seed(123199)
x <- rbernoulli(rep(5, 10))
ans0 <- count_stats(x, c("mutual", "edges"))

# Calculating using summary_formula
ans1 <- lapply(x, function(i) {
  ergm::summary_formula(i ~ mutual + edges)
})

ans1 <- do.call(rbind, ans1)

# Comparing
all.equal(unname(ans0), unname(ans1))

# count_stats is vectorized (and so faster)
bm <- benchmarkito(
  count_stats = count_stats(x, c("mutual", "edges")),
  lapply      = lapply(x, function(i) {
  ergm::summary_formula(i ~ mutual + edges)
}), times = 50
)

plot(bm)

}
