% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEnrichment.R
\name{plotEnrichment}
\alias{plotEnrichment}
\title{Plotting functions for enrichment lists}
\usage{
plotEnrichment(enepso, enesso, enepi, enepisem, enfenics, enspace, k)
}
\arguments{
\item{enepso}{list with enrichment for EpSO}

\item{enesso}{list with enrichment for ESSO}

\item{enepi}{list with enrichment for EPILONT}

\item{enepisem}{list with enrichment for EPISEM}

\item{enfenics}{list with enrichment for FENICS}

\item{enspace}{list with enrichment for the combined ranked list}

\item{k}{numeric value for the length to be plotted}
}
\value{
the plot object
}
\description{
Plotting functions for enrichment lists
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
    readAtcMapIntoHashMapDrugNamesAtcCodes(
        system.file("extdata", "db-atc.map", package = "epos"), "\t")
epso <- rawDrugNamesCoOcEpSO
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- rawDrugNamesCoOcESSO
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- rawDrugNamesCoOcEPILONT
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- rawDrugNamesCoOcEPISEM
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- rawDrugNamesCoOcFENICS
neurofenics <- filterNeuroDrugs(fenics, atchashda)
mx <- max(
    c(length(neuroepso), length(neuroesso), length(neuroepi),
      length(neuroepisem), length(neurofenics)))
dneuro <-
  data.frame(EpSO = c(neuroepso, rep("", (mx-length(neuroepso)))),
             ESSO = c(neuroesso, rep("", (mx-length(neuroesso)))),
             EPILONT = c(neuroepi, rep("", (mx-length(neuroepi)))),
             EPISEM = c(neuroepisem, rep("", (mx-length(neuroepisem)))),
             FENICS = c(neurofenics, rep("", (mx-length(neurofenics)))))
dneuromaxk <- TopKLists::calculate.maxK(dneuro, L=5, d=5, v=5)
neurospace <- as.character(dneuromaxk$topkspace)
enepso <- calcEnrichment(neuroepso)
enesso <- calcEnrichment(neuroesso)
enepi <- calcEnrichment(neuroepi)
enepisem <- calcEnrichment(neuroepisem)
enfenics <- calcEnrichment(neurofenics)
enspace <- calcEnrichment (neurospace)
p <- plotEnrichment(enepso, enesso, enepi, enepisem, enfenics, enspace, dneuromaxk$maxK)
}
