% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_preport_combined_month_ytd}
\alias{epitrax_preport_combined_month_ytd}
\title{Create combined monthly/YTD stats public report from an EpiTrax object}
\usage{
epitrax_preport_combined_month_ytd(epitrax)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}
}
\value{
Updated EpiTrax object with YTD rates report added to the
\code{public_reports} field.
}
\description{
\code{epitrax_preport_combined_month_ytd} generates a public report of
monthly and year-to-date (YTD) disease statistics for the report month
in the EpiTrax object data.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_preport_combined_month_ytd()

names(epitrax$public_reports)
}
