% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{effect_importance}
\alias{effect_importance}
\title{Variable Importance}
\usage{
effect_importance(x, by = NULL)
}
\arguments{
\item{x}{Object of class "EffectData".}

\item{by}{The statistic used to calculate the variance for.
One of 'pd', 'pred_mean', 'y_mean', 'resid_mean', or 'ale' (if available).
The default is \code{NULL}, which picks the first available statistic from above list.}
}
\value{
A named vector of importance values of the same length as \code{x}.
}
\description{
Extracts from an "EffectData" object a simple variable importance measure, namely
the (bin size weighted) variance of the partial dependence values, or of any other
calculated statistic (e.g., "pred_mean" or "y_mean"). It can be used via
\code{update.EffectData(, sort_by = "pd")} to sort the variables in decreasing importance.
Note that this measure captures only the main effect strength.
If the importance is calculated with respect to "pd", it is closely related
to the suggestion of Greenwell et al. (2018).
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
M <- feature_effects(fit, v = colnames(iris)[-1], data = iris)
effect_importance(M)
}
\references{
Greenwell, Brandon M., Bradley C. Boehmke, and Andrew J. McCarthy. 2018.
\emph{A Simple and Effective Model-Based Variable Importance Measure.}
arXiv preprint. \url{https://arxiv.org/abs/1805.04755}.
}
\seealso{
\code{\link[=update.EffectData]{update.EffectData()}}
}
