% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eddington-R6.r
\name{Eddington}
\alias{Eddington}
\title{An R6 Class for Tracking Eddington Numbers for Cycling}
\description{
The class will maintain the state of the algorithm, allowing for efficient
updates as new rides come in.
}
\section{Warnings}{


The implementation uses an experimental base R feature \link[utils:hashtab]{utils::hashtab}.

Cloning of \code{Eddington} objects is disabled. Additionally, \code{Eddington} objects
cannot be serialized; they cannot be carried between sessions using
\link[base:readRDS]{base::saveRDS} or \link[base:save]{base::save} and then loaded later using \link[base:readRDS]{base::readRDS}
or \link[base:load]{base::load}.
}

\examples{
# Randomly generate a set of 15 rides
rides <- rgamma(15, shape = 2, scale = 10)

# View the rides sorted in decreasing order
stats::setNames(sort(rides, decreasing = TRUE), seq_along(rides))

# Create the Eddington object
e <- Eddington$new(rides, store.cumulative = TRUE)

# Get the Eddington number
e$current

# Update with new data
e$update(rep(25, 10))

# See the new data
e$cumulative
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{current}}{The current Eddington number.}

\item{\code{cumulative}}{A vector of cumulative Eddington numbers.}

\item{\code{number_to_next}}{The number of rides needed to get to the next
Eddington number.}

\item{\code{n}}{The number of rides in the data.}

\item{\code{hashmap}}{The hash map of rides above the current Eddington number.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Eddington-new}{\code{Eddington$new()}}
\item \href{#method-Eddington-print}{\code{Eddington$print()}}
\item \href{#method-Eddington-update}{\code{Eddington$update()}}
\item \href{#method-Eddington-getNumberToTarget}{\code{Eddington$getNumberToTarget()}}
\item \href{#method-Eddington-isSatisfied}{\code{Eddington$isSatisfied()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Eddington-new"></a>}}
\if{latex}{\out{\hypertarget{method-Eddington-new}{}}}
\subsection{Method \code{new()}}{
Create a new Eddington object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Eddington$new(rides, store.cumulative = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rides}}{A vector of rides}

\item{\code{store.cumulative}}{logical, indicating whether to keep a vector of
cumulative Eddington numbers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Eddington} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Eddington-print"></a>}}
\if{latex}{\out{\hypertarget{method-Eddington-print}{}}}
\subsection{Method \code{print()}}{
Print the current Eddington number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Eddington$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Eddington-update"></a>}}
\if{latex}{\out{\hypertarget{method-Eddington-update}{}}}
\subsection{Method \code{update()}}{
Add new rides to the existing \code{Eddington} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Eddington$update(rides)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rides}}{A vector of rides}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Eddington-getNumberToTarget"></a>}}
\if{latex}{\out{\hypertarget{method-Eddington-getNumberToTarget}{}}}
\subsection{Method \code{getNumberToTarget()}}{
Get the number of rides of a specified length to get to a target
Eddington number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Eddington$getNumberToTarget(target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{Target Eddington number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer representing the number of rides of target length
needed to achieve the target number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Eddington-isSatisfied"></a>}}
\if{latex}{\out{\hypertarget{method-Eddington-isSatisfied}{}}}
\subsection{Method \code{isSatisfied()}}{
Test if an Eddington number is satisfied.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Eddington$isSatisfied(target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{Target Eddington number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
}
