% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.approximateRefSets.R
\name{approximateRefSets}
\alias{approximateRefSets}
\title{Helper function to estimate reference set(s).}
\usage{
approximateRefSets(df, obj.cols, as.df = FALSE)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame with the required structure.}

\item{obj.cols}{[\code{character(>= 2)}]\cr
Column names of the objective functions.}

\item{as.df}{[\code{logical(1)}]\cr
Should a data.frame be returned?
Default is \code{FALSE}. In this case a named list is returned.}
}
\value{
[\code{list} | \code{data.frame}] Named list of matrizes
(names are the problems) or data frame with columns \code{obj.cols} and \dQuote{prob}.
}
\description{
The function takes an data frame with columns at least
specified by \code{obj.cols} and \dQuote{prob}. The reference set for
each unique problem in column \dQuote{prob} is then obtained by
combining all approximation sets generated by all considered algorithms
for the corresponding problem and filtering the non-dominated solutions.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
