% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostatscale.R
\name{symdynN}
\alias{symdynN}
\title{Simulate time series for N species or patches}
\usage{
symdynN(
  r,
  amu,
  asd,
  f,
  d,
  d_sd,
  d_cov,
  N,
  sf,
  tmax,
  stochd = TRUE,
  stocht = TRUE,
  as.matrix = FALSE,
  amax = 0,
  amin = -Inf,
  Ifrac = NULL,
  Iloss = NULL,
  dffun = df0,
  fullout = FALSE,
  xstart = NULL,
  Ksim = 1
)
}
\arguments{
\item{r}{per-capita growth rate (r in Eq.2-3)}

\item{amu}{the mean interaction strength}

\item{asd}{standard deviation used to generate interaction strengths}

\item{f}{the waiting time (or average waiting time) between disturbance events (equal to 1/lambda in Eq.2-3)}

\item{d}{mean size of disturbance function (mu in Eq.2-3)}

\item{d_sd}{standard deviation of disturbance function (sigma in Eq.5)}

\item{d_cov}{the covariance for generating disturbances}

\item{N}{number of species or patches}

\item{sf}{waiting time between sampling events}

\item{tmax}{the time series length to be simulated}

\item{stochd}{a logical variable, indicating whether disturbance size should be stochastic - otherwise, all disturbances are of magnitude d - defaults to TRUE}

\item{stocht}{a logical variable, indicating whether waiting time between disturbance events should be stochastic - otherwise, waiting time is always f - defaults to TRUE}

\item{as.matrix}{indicates whether results should be returned as matrix (potentially faster for some applications) - defaults to FALSE}

\item{amax}{the maximum value allowed for interaction coefficients - defaults to zero}

\item{amin}{the minimum value allowed for interaction coefficients - defaults to -Inf}

\item{Ifrac}{dispersal rate (D in Eq. 2) - defaults to NULL (i.e. no dispersal)}

\item{Iloss}{loss rate from dispersal that falls outside of the patch - defaults to NULL}

\item{dffun}{the function handed to the ODE solver - should be df_col for spatial simulations, and df0 for multi-species simulations - defaults to df0}

\item{fullout}{a logical, determining whether the full output or just a summary is returned - defaults to fullout}

\item{xstart}{optional vector of starting abundances - defaults to NULL (i.e. no values)}

\item{Ksim}{carrying capacities - defaults to 1}
}
\value{
a matrix or data.frame with columns for sampling times, abundances, and number of disturbances for each time interval
}
\description{
Function for simulating dynamics from Eq.2-3 in the main text.
}
\examples{
### Example 1: 10 patches
r<-1 #rate of recovery
d<-(0) #mean size of disturbance (mu in text)
d_sd<-sqrt(0.1) #SD of disturbances (sigma in text)
f<-1 #average time between disturbances (1/lambda in text)
sf<-0.1 #sampling interval
tmax<-120 #maximum time for simulation
d_cov<-d_cov0<-(d_sd)^2/2 #covariance in disturbance size among patches

xtNpatches<-symdynN(r = r, amu=0, asd=0, f=f, d=d,
              d_sd=d_sd, d_cov=d_cov, N=10,
              sf=sf, tmax=tmax, Ifrac=0, dffun = df_col)


### Example 2: 30 species
r<-1 #rate of recovery
d<-(0) #mean size of disturbance (mu in text)
d_sd<-sqrt(0.1) #SD of disturbances (sigma in text)
f<-1 #average time between disturbances (1/lambda in text)
sf<-0.1 #sampling interval
tmax<-120 #maximum time for simulation
d_cov<-0 #covariance in disturbances among species
amu<-(-r/2) #average interaction coefficient
asd<-0.1 #standard deviation of interaction coefficient

xtNsp<-symdynN(r = r, amu=amu, asd=asd, f=f, d=d,
             d_sd=d_sd, d_cov=d_cov, N=30,
             sf=sf, tmax=tmax)
}
