% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{get.text.svg}
\alias{get.text.svg}
\title{Generate text SVG element}
\usage{
get.text.svg(x = NULL, y = NULL, text.content = "", fill, stroke,
  stroke.width, font.family, font.size, font.weight, font.style,
  text.decoration, word.spacing, letter.spacing, text.anchor, rotate, text.path,
  style.sheet = NULL)
}
\arguments{
\item{x}{a number, x coordinate information}

\item{y}{a number, y corrdinate information}

\item{text.content}{a character, text content}

\item{fill}{a character, color of the text, eg. "#000000"(default), "red"}

\item{stroke}{a characher, color of the rect text, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the rect text, default: 1}

\item{font.family}{a character, font family of text, eg. "Arial"}

\item{font.size}{a number, font size of text, default: 8}

\item{font.weight}{a character, font weight of text, eg. "normal"(default), "bold"}

\item{font.style}{a character, font style of text, eg. "normal"(default), "italic"}

\item{text.decoration}{a character, text decoration, eg. "none"(default), "underline", "overline", "line-through"}

\item{word.spacing}{a number or character, default: "normal"}

\item{letter.spacing}{a number or character, defailt: "normal"}

\item{text.anchor}{a character, eg. "start"(default), "middle", "end"}

\item{rotate}{a number, rotation angle of text}

\item{text.path}{a character, fit text path}

\item{style.sheet}{a vector or a chatacter, other style of the text, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function can generate a text form SVG element
The SVG <text> element defines a graphics element consisting of text.
It's possible to apply a gradient, pattern, clipping path, mask, or
filter to <text>, just like any other SVG graphics element.
}
\examples{
get.text.svg(x = 10, y = 20, text.content = "Hello Word", fill = "blue")
get.text.svg(x = 10, y = 20, text.content = "Hello Word", fill = "blue",
             rotate = 90, font.family = "Helvetica")

}
