% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_classes_and_methods.R
\name{get_epm_data}
\alias{get_epm_data}
\title{Get Processed Data from an easyPubMed Object.}
\usage{
get_epm_data(x)
}
\arguments{
\item{x}{An `easyPubMed` object.}
}
\value{
a `data.frame` including processed data from an `easyPubMed` object.
}
\description{
Obtain Processed Data that were extracted from a list of PubMed records. 
This is a wrapper function that calls 
the `getEPMData()` method. This function returns contents 
from the `data` slot.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  x <- epm_fetch(x)
  x <- epm_parse(x, max_references = 5, max_authors = 5)
  get_epm_data(x)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

 
}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
