% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{cv.alpha}
\alias{cv.alpha}
\title{Cross-validation runs for risk predition at a single value of alpha}
\usage{
cv.alpha(
  x,
  y,
  folds = 10,
  alpha = 0.5,
  nlamb = 100,
  verb = 0,
  scorefunc,
  plot = FALSE
)
}
\arguments{
\item{x}{The data matrix to use for predictions}

\item{y}{The response for coxnet; preferably a preconstructed Surv-object}

\item{folds}{Number of cross-validation folds}

\item{alpha}{Chosen L1/L2 norm parameter lambda}

\item{nlamb}{Number of lambda values}

\item{verb}{Integer indicating level of verbosity, where 0 is silent and 1 provides additional information}

\item{scorefunc}{Chosen scoring function, e.g. score.cindex or score.iAUC}

\item{plot}{Should a CV-performance curve be plotted as a function of lambda, indicating min/max/mean/median of CV performance over the folds}
}
\value{
A matrix of cross-validation scores, where rows correspond to CV folds and columns to various lambda values chosen by glmnet
}
\description{
Run n-fold cross-validation for a chosen prediction metric at a single value of the L1/L2 norm alpha. A suitable lambda sequence is determined by glmnet, and the cross-validation returns a prediction matrix over the folds over various lambda. This function is mostly called by the higher hierarchy functions, such as cv.grid, which allows varying also the alpha-parameter.
}
\examples{
data(TYKSSIMU)
library(survival)
ydat <- Surv(event = yMEDISIMU[,"DEATH"], time = yMEDISIMU[,"LKADT_P"])
set.seed(1)
cvs <- cv.alpha(x = xMEDISIMU, y = ydat, alpha = 0.5, folds = 5, 
	nlamb = 50, verb = 1, scorefunc = score.cindex, plot = TRUE)
cvs
}
