% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateCV.R
\name{annotateCV}
\alias{annotateCV}
\title{Annotate Cyclic Voltammogram}
\usage{
annotateCV(filename, main_title = NULL, forward.per = 5, reverse.per = 5,
  threshold = 0.05)
}
\arguments{
\item{filename}{Name of the file that contains the results of a simulated cyclic voltammetry experiment.}

\item{main_title}{An optional main title.}

\item{forward.per}{The percentage of points from the beginning of the forward scan used to set the baseline for measuring the peak current.}

\item{reverse.per}{The percentage of points from the beginning of the reverse scan used to set the baseline for measuring the peak current.}

\item{threshold}{Sets the smallest measurable current.}
}
\value{
Returns a plot of the cyclic voltammogram with annotations.
}
\description{
Plots a cyclic voltammogram and annotates it with values for the cathodic peak potential (Epc), the anodic peak potential (Epa), the difference in peak potentials (Delta E), the cathodic peak current (ip,c), the anodic peak current (ip,a), and the peak current ratio (either ip,c/ip,a or ip,a/ip,c). The baseline for determining peak currents is set using a defined percentage of points at the beginning of the forward and the reverse scans. Values are reported as unmeasurable when they fall below a threshold value.
}
\examples{

cv_ex2 = simulateCV(ko = 0.01, e.switch = -0.8, e.form = -0.4,
  x.units = 100, t.units = 1000)
annotateCV(cv_ex2)
}
