% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_root.R
\name{add_root}
\alias{add_root}
\alias{add_root_using_expression}
\alias{is_rooted}
\alias{remove_root}
\title{Root the trajectory}
\usage{
add_root(
  trajectory,
  root_cell_id = trajectory$root_cell_id,
  root_milestone_id = trajectory$root_milestone_id,
  flip_edges = TRUE
)

add_root_using_expression(
  trajectory,
  features_oi,
  expression_source = "expression"
)

is_rooted(trajectory)

remove_root(trajectory)
}
\arguments{
\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}

\item{root_cell_id}{The root cell id, not required if root_milestone_id is given}

\item{root_milestone_id}{The root milestone id, not required if root_cell_id is given}

\item{flip_edges}{Whether to flip edges which are going in the other direction compared to the root}

\item{features_oi}{The feature ids which will be used to root}

\item{expression_source}{Source of the expression, either a string or a matrix}
}
\value{
A trajectory, with a \emph{root_milestone_id} and with adapted \emph{milestone_network} and \emph{progressions} based on the rooting.
}
\description{
Designates a milestone as root, and changes the direction of any edges so that they move away from the specified root (if \code{flip_edges=TRUE}, default).
}
\details{
A \code{root_cell_id} can also be specified, and the root milestone will be determined as the milestone with the closest geodesic distance to this cell.
}
\examples{
# add a root using a root cell
trajectory <- example_trajectory
trajectory <- add_root(
  trajectory,
  root_cell_id = sample(trajectory$cell_ids, 1)
)
trajectory$root_milestone_id

# add a root using a root milestone id
trajectory <- add_root(
  trajectory,
  root_milestone_id = "milestone_end"
)
trajectory$root_milestone_id
trajectory$milestone_network

}
\keyword{adapt_trajectory}
