% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_integer_range.R
\name{integer_range_parameter}
\alias{integer_range_parameter}
\title{Define a integer range parameter}
\usage{
integer_range_parameter(
  id,
  default,
  lower_distribution,
  upper_distribution,
  description = NULL,
  tuneable = TRUE
)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{lower_distribution}{A distribution from which the lower value of the range can be sampled.}

\item{upper_distribution}{A distribution from which the upper value fo the range can be sampled.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a integer range parameter
}
\examples{
integer_range_parameter(
  id = "ks",
  default = c(3L, 15L),
  lower_distribution = uniform_distribution(1L, 5L),
  upper_distribution = uniform_distribution(10L, 20L),
  description = "The numbers of clusters to be evaluated."
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
