% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dynamic_coords.R
\name{extract_dynamic_coords}
\alias{extract_dynamic_coords}
\title{Extract temporally dynamic explanatory variable data for occurrence records.}
\usage{
extract_dynamic_coords(
  occ.data,
  datasetname,
  bandname,
  spatial.res.metres,
  GEE.math.fun,
  save.method,
  temporal.res,
  temporal.direction,
  varname,
  resume = FALSE,
  save.directory
)
}
\arguments{
\item{occ.data}{a data frame, with columns for occurrence record co-ordinates and dates with
column names as follows; record longitude as "x", latitude as "y", year as "year", month as
"month", and day as "day".}

\item{datasetname}{a character string, the Google Earth Engine dataset to extract data from.}

\item{bandname}{a character string, the Google Earth Engine dataset bandname to extract data for.}

\item{spatial.res.metres}{a numeric value, the spatial resolution in metres for data extraction.}

\item{GEE.math.fun}{a character string, the mathematical function to compute across the
\code{temporal.res} period for each record.}

\item{save.method}{a character string, the method used to save extracted variable data. One of
\code{split} or \code{combined}: can be abbreviated. See details.}

\item{temporal.res}{a numeric value, the temporal resolution in days to extract data and
calculate \code{GEE.math.fun} across from each record's date.}

\item{temporal.direction}{a character string, the temporal direction for extracting data across
relative to the record date. One of \code{prior} or \code{post}: can be abbreviated.}

\item{varname}{optional; a character string, the unique name for the explanatory variable.
Default varname is "bandname_temporal.res_temporal.direction_ GEE.math.fun".}

\item{resume}{a logical indicating whether to search \code{save.directory} and start from previous
progress by function. Only possible if \code{save.method} = \code{split} has been used.}

\item{save.directory}{a character string, the path to a local directory to save extracted
variable data to.}
}
\value{
Returns details of successful explanatory variable extractions.
}
\description{
For each species occurrence record co-ordinate and date, temporally dynamic explanatory data are
extracted using Google Earth engine
}
\details{
For each individual species occurrence record co-ordinate and date, this function extracts data
for a given band within a Google Earth Engine dataset across a user-specified period and
calculates a mathematical function on such data.
}
\section{Google Earth Engine}{
\code{extract_dynamic_coords()} requires users to have installed R package \code{rgee} (Aybar et al.,
2020) and initialised Google Earth Engine with valid log-in credentials. Please follow
instructions on the following website \url{https://cran.r-project.org/package=rgee}.
\itemize{
\item \code{datasetname} must be in the accepted Google Earth Engine catalogue layout (e.g.
\code{"MODIS/006/MCD12Q1"} "or \code{"UCSB-CHG/CHIRPS/DAILY"})
\item \code{bandname} must be as specified under the
dataset in the Google Earth Engine catalogue (e.g. \code{"LC_Type5"}, \code{"precipitation"}). For
datasets
and band names, see \url{https://developers.google.com/earth-engine/datasets}.
}
}

\section{Mathematical function}{
\code{GEE.math.fun} specifies the mathematical function to be calculated over the temporal period
from each record's date. Options are limited to Google Earth Engine ImageCollection Reducer
functions (\url{https://developers.google.com/earth-engine/apidocs/}) for which an analogous R
function is available. This includes: "allNonZero","anyNonZero", "count",
"first","firstNonNull", "last", "lastNonNull", "max","mean", "median","min", "mode","product",
"sampleStdDev", "sampleVariance", "stdDev", "sum" and "variance".
}

\section{Categorical data}{
Please be aware, at current this function does not support the extraction of temporally dynamic
variables for specific categories within categorical datasets.

When extracting from categorical datasets, be careful to choose appropriate mathematical
functions for such data. For instance, "first" or "last" may be more relevant that "sum" of land
cover classification numbers.
}

\section{Exporting extracted data}{
For \code{save.method} = \code{combined}, the function with save “csv” files containing all occurrence
records and associated values for the explanatory variable.

For \code{save.method} = \code{split}, the function will save individual “csv” files for each record with
each unique period of the given temporal.level (e.g. each year, each year and month combination
or each unique date).

\code{split} protects users if internet connection is lost when extracting data for large occurrence
datasets. The argument \code{resume} can be used to resume to previous progress if connection is
lost.
}

\examples{
\dontshow{if (googledrive::drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

data(sample_filt_data)

\dontshow{
sample_filt_data<-sample_filt_data[1,]
}

extract_dynamic_coords(occ.data=sample_filt_data,
 datasetname = "UCSB-CHG/CHIRPS/DAILY",
 bandname="precipitation",
 spatial.res.metres = 5566 ,
 GEE.math.fun = "sum",
 temporal.direction = "prior",
 temporal.res = 364,
 save.method = "split",
 resume = TRUE,
 varname = "total_annual_precipitation_prior",
 save.directory= tempdir())

\dontshow{\}) # examplesIf}
}
\references{
Aybar, C., Wu, Q., Bautista, L., Yali, R. and Barja, A., 2020. rgee: An R package for
interacting with Google Earth Engine. Journal of Open Source Software, 5(51), p.2272.
}
