% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_smooth_timeseries.R
\name{op_smooth_timeseries}
\alias{op_smooth_timeseries}
\title{Smooth Time Series Data with Various Methods}
\arguments{
\item{data}{A data frame containing the time series data. Must include \code{person}, \code{time}, and keypoints (e.g., \code{x0}, \code{y0}, etc.).}

\item{method}{The smoothing method to use. Options are "zoo" (moving average),
"kza" (Kalman-Ziegler Adaptive), "savitzky" (Savitzky-Golay filter),
and "butterworth" (Butterworth filter). Default is "zoo".}

\item{kza_k}{Window size for the KZA method. Default is 3.}

\item{kza_m}{Number of iterations for the KZA method. Default is 2.}

\item{rollmean_width}{Width of the moving average window for the zoo method. Default is 3.}

\item{sg_window}{Window size for the Savitzky-Golay filter. Default is 5.}

\item{sg_order}{Polynomial order for the Savitzky-Golay filter. Default is 3.}

\item{butter_order}{Order of the Butterworth filter. Default is 3.}

\item{butter_cutoff}{Cutoff frequency for the Butterworth filter. Default is 0.1.}

\item{side}{Character string indicating which side of the data to smooth.
Options are "left", "right", or "both". Default is "both".}

\item{plot}{Logical, if TRUE, the function will generate a plot comparing the original
and smoothed data. If FALSE, the function returns only the smoothed data frame without plotting. Default is TRUE.}

\item{keypoints}{Vector of keypoint column names (e.g., \code{x0}, \code{x1}) to be smoothed and included in the plot.
If NULL, all keypoints beginning with \code{x} or \code{y} will be smoothed and plotted. Default is NULL.}
}
\value{
A data frame with the smoothed time series data for the specified keypoints. If \code{plot = TRUE}, a plot is displayed comparing the original and smoothed data.
}
\description{
This function applies different smoothing techniques to time series data
for the selected columns (keypoints), including moving average, Kalman-Ziegler Adaptive (KZA),
Savitzky-Golay filter, and Butterworth filter. It can optionally plot the
smoothed data alongside the original data, with faceting based on the \code{person} and \code{keypoint} columns.
}
\examples{
# Load example data from the package
data_path <- system.file("extdata/csv_data/dyad_1/A_body.csv", package = "duet")
data <- read.csv(data_path)

# Smooth the time series data using the Savitzky-Golay filter
smoothed_data <- op_smooth_timeseries(
  data = data,
  method = "savitzky",
  sg_window = 5,
  sg_order = 3,
  plot = TRUE,
  keypoints = c("x0", "y0") # Specify keypoints to smooth
)

# Print the smoothed data
print(smoothed_data)
}
