% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_animate_dyad.R
\name{op_animate_dyad}
\alias{op_animate_dyad}
\title{Animate OpenPose data for a dyad across a range of frames (Video)}
\usage{
op_animate_dyad(
  data,
  output_file,
  lines = FALSE,
  keylabels = FALSE,
  label_type = "names",
  fps = 24,
  min_frame = NULL,
  max_frame = NULL,
  hide_labels = FALSE,
  left_color = "blue",
  right_color = "red",
  background_color = "white",
  background_colour = NULL
)
}
\arguments{
\item{data}{A dataframe containing OpenPose data.}

\item{output_file}{A character string specifying the path and filename for the output video file.}

\item{lines}{A logical value indicating whether to draw lines connecting joints. Default is FALSE.}

\item{keylabels}{A logical value indicating whether to label keypoints. Default is FALSE.}

\item{label_type}{A character string specifying the type of labels to use: "names" or "numbers". Default is "names".}

\item{fps}{An integer specifying the frames per second for the video. Default is 24.}

\item{min_frame}{An optional integer specifying the minimum frame to include in the video. Default is the first frame in the data.}

\item{max_frame}{An optional integer specifying the maximum frame to include in the video. Default is the last frame in the data.}

\item{hide_labels}{A logical value indicating whether to hide the x and y axes, box, and title. Default is FALSE.}

\item{left_color}{A character string specifying the color to use for the left person. Default is "blue".}

\item{right_color}{A character string specifying the color to use for the right person. Default is "red".}

\item{background_color}{A character string specifying the background color of the plot. Default is "white". (US English)}

\item{background_colour}{A character string specifying the background colour of the plot. Default is "white". (UK English)}
}
\value{
No return value. This function generates a video file as a side effect, saved at the specified output path.
}
\description{
This function generates a video of the OpenPose data for both persons in a dyad across a specified range of frames.
}
\examples{
\dontrun{
# Example OpenPose data
data <- data.frame(
  frame = rep(1:10, each = 2),
  person = rep(c("left", "right"), times = 10),
  x0 = runif(20, 0, 1920), y0 = runif(20, 0, 1080),
  x1 = runif(20, 0, 1920), y1 = runif(20, 0, 1080)
)

# Output file path
output_file <- tempfile("output_video", fileext = ".mp4")

# Generate video
op_animate_dyad(
  data = data,
  output_file = output_file,
  fps = 24,
  left_color = "blue",
  right_color = "red"
)
}
}
