% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subscription_key.R
\name{get_subscription_key}
\alias{get_subscription_key}
\title{Retrieval of an API subscription key from the environment.}
\usage{
get_subscription_key()
}
\value{
A string representing a given subscription key for the DTM API.
}
\description{
The DTM API subscription key is returned, provided that it is available in
the R session as an environment variable. Users will usually need to set
the DTM_SUBSCRIPTION_KEY environment variable through a .Renviron file or
by calling \code{set_subscription_key()}.
}
\details{
On the other hand, if the TESTTHAT environment variable is true, indicating
that unit tests are being run by the package maintainers, then the
subscription key is returned through different means.
}
\examples{
\dontrun{
# Generally, calling set_subscription_key() without the key as an argument is best, 
# as the user can then be prompted to input the key without typing it directly
# into the console, making it more secure and less likely to exposed.
set_subscription_key()
}
}
