% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_sim.R
\name{dtl_app_get_alpha_t_sim}
\alias{dtl_app_get_alpha_t_sim}
\title{Numerical minimum significance level for the final stage under
drop-the-losers (DTL) design}
\usage{
dtl_app_get_alpha_t_sim(
  nsim = 1e+05,
  n,
  N,
  q_seq,
  gamma_seq,
  alpha,
  fix_rho = NULL,
  sel_g_func = sel_g_func_default,
  ...
)
}
\arguments{
\item{nsim}{Number of replicates.}

\item{n}{Number of patients per treatment arm at the DTL look}

\item{N}{Total number of patients in both selected and control arms
at final analysis.}

\item{q_seq}{A vector of response rates under the null (can be 95\% CI).}

\item{gamma_seq}{A vector of hazards ratios of responders and non-responders
(can be 95\% CI).}

\item{alpha}{A pre-specified FWER.}

\item{fix_rho}{Use fixed correlation coefficient or use theoretical upper
bound to get alpha_t. If = NULL, then it uses upper bound;
else if = real number between 0 and 1, then it use such
number as fixed correlation coefficient.}

\item{sel_g_func}{Arm-select function. The default function is
sel_g_func_default(W_2, W_1, delta). Users can define
their own arm-select function. The format of
the function must be function_name(W_2, W_1, ...). The
return values must be 1 (arm 1 is selected) or 2 (arm 2
is selected) or 0 (stop for futility).}

\item{...}{Other arguments from sel_g_func.}
}
\value{
A list of two data frames for numerical minimum significance level
alpha_t and significance level alpht_s given all combinations of q_seq
and gamma_seq.
}
\description{
Get numerical minimum significance level alpha_t (minimum of alpha_s)
for the final analysis considering the ranges of response rate q and
hazard ratio of responders and non-responders gamma given a pre-specified
FWER alpha
}
\examples{
\donttest{
# Inputs
set.seed(1000)
nsim      = 100000
n         = 80    
N         = 152   
q_seq     = seq(0.19, 0.32, 0.01) 
gamma_seq = seq(0.14, 0.34, 0.01) 
alpha     = 0.025
delta     = 0.05  

# Use fixed correlation coefficient
dtl_app_get_alpha_t_sim(nsim, n, N, q_seq, gamma_seq, alpha, 
                        fix_rho = 1, delta = delta)

# Use theoretical upper bound 
dtl_app_get_alpha_t_sim(nsim, n, N, q_seq, gamma_seq, alpha, 
                        fix_rho = NULL, delta = delta)
}

}
