% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmean_fn.R
\name{estimate_eif_wmean}
\alias{estimate_eif_wmean}
\title{Obtain an estimate of the efficient influence function for the 
treatment-specific weighted mean parameter}
\usage{
estimate_eif_wmean(
  trt_spec_cond_mean_est,
  trt_spec_prob_est,
  trt_level,
  out,
  treat
)
}
\arguments{
\item{trt_spec_cond_mean_est}{Conditional mean for \code{trt_level}}

\item{trt_spec_prob_est}{Propensity for \code{trt_level}}

\item{trt_level}{Treatment level}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}
}
\description{
Obtain an estimate of the efficient influence function for the 
treatment-specific weighted mean parameter
}
