% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_kpm.R
\name{get_survdiff}
\alias{get_survdiff}
\title{Test Survival Curve Differences}
\usage{
get_survdiff(kds, cond, test_type)
}
\arguments{
\item{kds}{data set of a survival model such as \code{\link[=do_kpm]{do_kpm()}}}

\item{cond}{character of experimental condition variable in the data}

\item{test_type}{numeric (0 or 1) parameter that controls the type of test (0 means rho = 0; log-rank,
1 means rho = 1; Peto & Peto Wilcox)}
}
\value{
Returns survival test results as called from \code{\link[survival:survdiff]{survival::survdiff()}}.
}
\description{
This function compares survival curves as modeled with \code{\link[=do_kpm]{do_kpm()}}.
It outputs a contingency table and a Chisq measure of difference.
}
\examples{
kpm_est <- do_kpm(add_dropout_idx(dropRdemo, 3:54))
get_survdiff(kpm_est$d, "experimental_condition", 0)
get_survdiff(kpm_est$d, "experimental_condition", 1)


}
