% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcr2pp.R
\name{qpcr2pp}
\alias{qpcr2pp}
\title{qPCR to Poisson Process}
\usage{
qpcr2pp(data, cyc = 1, fluo = NULL, Cq_range = c(min(data[cyc]) + 6,
  max(data[cyc]) - 6), model = l5, SDM = TRUE, NuEvents = 1,
  delta = 1, exper = "qPCR1", replicate = 1, assay = "Unknown",
  type = "np")
}
\arguments{
\item{data}{a dataframe containing the qPCR data.}

\item{cyc}{the column containing the cycle data. Defaults to first column.}

\item{fluo}{the column(s) (runs) to be analyzed. If \code{NULL}, all runs will be
considered (equivalent of \code{(1L:ncol(data))[-cyc]}).}

\item{Cq_range}{is a user defined range of cycles to be used for the
determination of the Cq values.}

\item{model}{is the model to be used for the analysis for all runs. Defaults
to 'l5' (see \code{\link[qpcR]{pcrfit}}).}

\item{SDM}{if \code{TRUE}, Cq is approximated by the second derivative
method.  If \code{FALSE}, Cy0 method is used instead.}

\item{NuEvents}{"number of expected events" within a time frame
(interval).}

\item{delta}{difference "time (cycles) points" e.g., Cycle 18 and 25.}

\item{exper}{The id of experiments.}

\item{replicate}{The id of technical replicates.}

\item{assay}{The name or id of assays.}

\item{type}{object of class \code{"character"} defining type of data. Could
be \code{"np"} (status (positive (1) or negative(0)) of each droplet) or\code{"ct"} 
(threshold cycle).}
}
\value{
An object of \code{\linkS4class{qdpcr}} class.
}
\description{
Describes qPCR as Poisson process.
}
\details{
Selected platforms (e.g., Open Array) are real-time platforms. dPCR can be
described by Poisson statistics. The function \code{qpcr2pp} takes a step
further and interprets the dPCR as a Poisson process if it is analyzed as a
"time" based process.

The dPCR Technology breaks fundamentally with the previous concept of
nucleic acid quantification. dPCR can be seen as a next generation nucleic
acid quantification method based on PCR. The key difference between dPCR and
traditional PCR lies in the method of measuring (absolute) nucleic acids
amounts. This is possible after ``clonal DNA amplification'' in thousands of
small separated partitions (e.g., droplets, nano chambers).  Partitions with
no nucleic acid remain negative and the others turn positive. Selected
technologies (e.g., OpenArray(R) Real-Time PCR System) monitor amplification
reactions in the chambers in real-time. Cq values are calculated from the
amplification curves and converted into discrete events by means of positive
and negative partitions and the absolute quantification of nucleic acids is
done by Poisson statistics.

PCR data derived from a qPCR experiment can be seen as a series of events
over time. We define t_i as the time between the first (i - 1)^st and the
i^th event. Therefore, the time \eqn{S_n}{S_n} is the sum of all
\eqn{t_i}{t_i} from \eqn{i = 1}{i = 1} to \eqn{i = n}{i = n}. This is the
time to the n^th event. \eqn{S(t)}{S(t)} is the number of events in \eqn{[0,
t]}{[0, t]}. This can be seen as a Poisson process. The Poisson statistics
is the central theorem to random processes in digital PCR.

The function \code{qpcr2pp} is used to model random point events in time
units (PCR cycles), such as the increase of signal during a qPCR reaction in
a single compartment. A Poisson process can be used to model times at which
an event occurs in a "system". The \code{qpcr2pp} (quantitative Real-Time
PCR to Poisson process) function transforms the qPCR amplification curve
data to quantification points (Cq), which are visualized as Poisson process.
This functions helps to spot differences between replicate runs of digital
PCR experiments. In ideal scenarios the \code{qpcr2pp} plots are highly
similar.

This tool might help to spot differences between experiments (e.g.,
inhibition of amplification reactions, influence of the chip arrays). The
qPCR is unique because the amplification of conventional qPCRs takes place
in discrete steps (cycles: 1, 2 ... 45), but the specific Cq values are
calculated with continuous outcomes (Cq: 18.2, 25.7, ...). Other
amplification methods such as isothermal amplifications are time based and
thus better suited for Poisson process.
}
\examples{

library(qpcR)
test <- cbind(reps[1L:45, ], reps2[1L:45, 2L:ncol(reps2)], 
	      reps3[1L:45, 2L:ncol(reps3)])

# before interpolation qPCR experiment must be converted into dPCR
qpcrpp <- qpcr2pp(data = test, cyc = 1, fluo = NULL, Cq_range = c(20, 30), 
                  model = l5, delta = 5)
summary(qpcrpp)
}
\author{
Stefan Roediger, Michal Burdukiewicz.
}
\keyword{Poisson}
\keyword{Process}
\keyword{qPCR}
