% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{sum.effect}
\alias{sum.effect}
\title{Sum of direct and indirect effects from dynamic path analysis}
\usage{
\method{sum}{effect}(effect1, effect2, ...)
}
\arguments{
\item{effect1}{an object of class "effect" obtained from a call to the function effect()}

\item{effect2}{a second object of class "effect" obtained from a call to the function effect()}

\item{...}{additional objects of class "effect" (any number of effects allowed)}
}
\value{
an object of class "effect" containing the sum of effect1, effect2, ...
}
\description{
a sum method for class "effect"
}
\examples{
library(dpasurv)

data(simdata)

set.seed(1)

# Perform dynamic path analysis:
# We set boot.n=30 for the example to run fast, should be set large enough
# so that results don't change meaningfully for different seeds.
s <- dpa(Surv(start,stop,event)~M+x, list(M~x), id="subject", data=simdata, boot.n=30)

direct <- effect(x ~ outcome, s)
indirect <- effect(x ~ M ~ outcome, s)
total <- sum(direct, indirect)

}
