% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{reconIgPhyML}
\alias{reconIgPhyML}
\title{Do IgPhyML maximum parsimony reconstruction}
\usage{
reconIgPhyML(
  file,
  modelfile,
  id,
  igphyml = "igphyml",
  mode = "switches",
  type = "recon",
  nproc = 1,
  quiet = 0,
  rm_files = FALSE,
  rm_dir = NULL,
  states = NULL,
  palette = NULL,
  resolve = 2,
  rseed = NULL,
  force_resolve = FALSE,
  ...
)
}
\arguments{
\item{file}{IgPhyML lineage file (see writeLineageFile)}

\item{modelfile}{File specifying parsimony model}

\item{id}{id for IgPhyML run}

\item{igphyml}{location of igphyml executable}

\item{mode}{return trees or count switches? (switches or trees)}

\item{type}{get observed switches or permuted switches?}

\item{nproc}{cores to use for parallelization}

\item{quiet}{amount of rubbish to print}

\item{rm_files}{remove temporary files?}

\item{rm_dir}{remove temporary directory?}

\item{states}{states in parsimony model}

\item{palette}{deprecated}

\item{resolve}{level of polytomy resolution. 0=none, 
1=maximum parsimony, 2=maximum ambiguity}

\item{rseed}{random number seed if desired}

\item{force_resolve}{continue even if polytomy resolution fails?}

\item{...}{additional arguments}
}
\value{
Either a tibble of switch counts or a list
          of trees with internal nodes predicted by parsimony.
}
\description{
\code{reconIgPhyML} IgPhyML parsimony reconstruction function
}
