% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{readBEAST}
\alias{readBEAST}
\title{Reads in a BEAST output directory}
\usage{
readBEAST(
  clones,
  dir,
  id,
  beast,
  burnin = 10,
  trait = NULL,
  nproc = 1,
  quiet = 0,
  full_posterior = FALSE,
  asr = FALSE,
  low_ram = TRUE
)
}
\arguments{
\item{clones}{either a tibble (getTrees) or list of \code{airrClone} objects}

\item{dir}{directory where BEAST output files have been placed.}

\item{id}{unique identifer for this analysis}

\item{beast}{location of beast binary directory (beast/bin)}

\item{burnin}{percent of initial tree samples to discard (default 10)}

\item{trait}{Trait coolumn used}

\item{nproc}{Number of cores for parallelization. Uses at most 1 core per tree.}

\item{quiet}{amount of rubbish to print to console}

\item{full_posterior}{Read un full distribution of parameters and trees?}

\item{asr}{Log ancestral sequences?}

\item{low_ram}{run with less memory (slightly slower)}
}
\value{
If data is a tibble, then the input clones tibble with additional columns for 
trees and parameter estimates given the specified burnin. If input is just a 
list of airrClone objects, it will return the corresponding list of trees
given the burnin
}
\description{
\code{readBEAST} Reads in data from BEAST output directory
}
