% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.optimal_bins}
\alias{plot.optimal_bins}
\title{Visualize Distribution for an "optimal_bins" Object}
\usage{
\method{plot}{optimal_bins}(
  x,
  type = c("all", "dist", "freq", "posrate", "WoE"),
  typographic = TRUE,
  base_family = NULL,
  rotate_angle = 0,
  ...
)
}
\arguments{
\item{x}{an object of class "optimal_bins", usually, a result of a call to binning_by().}

\item{type}{character. options for visualization. Distribution ("dist"), Relateive Frequency ("freq"),
Positive Rate ("posrate"), and Weight of Evidence ("WoE"). and default "all" draw all plot.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{rotate_angle}{integer. specifies the rotation angle of the x-axis label. 
This is useful when the x-axis labels are long and overlap. 
The default is 0 to not rotate the label.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
An object of gtable class.
}
\description{
It generates plots for understand distribution, frequency, bad rate, and weight of evidence using optimal_bins.

See vignette("transformation") for an introduction to these concepts.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "creatinine"] <- NA

# optimal binning using binning_by()
bin <- binning_by(heartfailure2, "death_event", "creatinine")

if (!is.null(bin)) {
  # visualize all information for optimal_bins class
  plot(bin)

  # rotate the x-axis labels by 45 degrees so that they do not overlap.
  plot(bin, rotate_angle = 45)

  # visualize WoE information for optimal_bins class
  plot(bin, type = "WoE")

  # visualize all information with typographic
  plot(bin)
}

}
\seealso{
\code{\link{binning_by}}, \code{\link{summary.optimal_bins}}
}
