% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvPlot.R
\name{plotCumInc}
\alias{plotCumInc}
\title{Plot Estimated Cumulative Incidence Function}
\usage{
plotCumInc(hazards, eventFocus = NULL, ...)
}
\arguments{
\item{hazards}{Numeric matrix (where each column represents one event) or vector of estimated hazards("numeric matrix").}

\item{eventFocus}{Column that represent the primary event ("integer vector"). 
Only applicable in the case of competing risks.}

\item{...}{Further arguments passed to \code{\link{plot}}.}
}
\description{
Generates a plot of an estimated cumulative incidence function P(T <= t, event=k | x) based on estimated hazards
of a discrete competing risks model or a discrete subdistribution hazard model.
}
\examples{

# Example with unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
SubUnempDur <- UnempDur [1:100, ]

################################
# Competing risks model 

# Estimate GEE models for all events
estGEE <- compRisksGEE(datShort = SubUnempDur, dataTransform = "dataLongCompRisks", 
corstr = "independence", formulaVariable =~ timeInt + age + ui + logwage * ui, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell")

# Estimate hazards of all events given the covariates of third person
SubUnempDurLong <- dataLongCompRisks(dataShort = SubUnempDur, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell") 
preds <- predict(estGEE, subset(SubUnempDurLong, obj == 3))

plotCumInc(preds, eventFocus = 3)


###############################
# Subdistribution hazards model

# Convert to long format
SubUnempDurLong <- dataLongSubDist(dataShort = SubUnempDur, timeColumn = "spell", 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), eventFocus = "censor1")

# Estimate continuation ratio model with logit link
glmFit <- glm(formula = y ~ timeInt + age + ui + logwage * ui, data = SubUnempDurLong, 
family = binomial(), weights = SubUnempDurLong$subDistWeights)

# Estimated subdistribution hazard given the covariates of the third person
preds <- predict(glmFit, type = "response", newdata = subset(SubUnempDurLong, obj == 3))

plotCumInc(preds)

}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{estSurv}}, \code{\link{estCumInz}}, \code{\link{compRisksGEE}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{discrete}
\keyword{survival}
