% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty.R
\name{pretty_num}
\alias{pretty_num}
\title{Prettify big numbers into a readable format}
\usage{
pretty_num(
  value,
  prefix = "",
  gbp = FALSE,
  suffix = "",
  dp = 0,
  ignore_na = FALSE,
  alt_na = FALSE,
  nsmall = NULL
)
}
\arguments{
\item{value}{value to be prettified}

\item{prefix}{prefix for the value, if "+/-" then it will automatically
assign + or - based on the value}

\item{gbp}{whether to add the pound symbol or not, defaults to not}

\item{suffix}{suffix for the value, e.g. "\%"}

\item{dp}{number of decimal places to round to, 0 by default.}

\item{ignore_na}{whether to skip function for strings that can't be
converted and return original value}

\item{alt_na}{alternative value to return in place of NA, e.g. "x"}

\item{nsmall}{minimum number of digits to the right of the decimal point.
If NULL, the value of \code{dp} will be used.
If the value of \code{dp} is less than 0, then \code{nsmall} will
automatically be set to 0.}
}
\value{
string featuring prettified value
}
\description{
Uses \code{as.numeric()} to force a numeric value and then formats prettily
for easy presentation in console messages, reports, or dashboards.

This rounds to 0 decimal places by default, and adds in comma separators.

Expect that this will commonly be used for adding the pound symbol,
the percentage symbol, or to have a +/- prefixed based on the value.

If applying over multiple or unpredictable values and you want to preserve
a non-numeric symbol such as "x" or "c" for data not available, use the
\code{ignore_na = TRUE} argument to return those values unaffected.

If you want to customise what NA values are returned as, use the \code{alt_na}
argument.

This function silences the warning around NAs being introduced by coercion.
}
\examples{
# On individual values
pretty_num(5789, gbp = TRUE)
pretty_num(564, prefix = "+/-")
pretty_num(567812343223, gbp = TRUE, prefix = "+/-")
pretty_num(11^9, gbp = TRUE, dp = 3)
pretty_num(-11^8, gbp = TRUE, dp = -1)
pretty_num(43.3, dp = 1, nsmall = 2)
pretty_num("56.089", suffix = "\%")
pretty_num("x")
pretty_num("x", ignore_na = TRUE)
pretty_num("nope", alt_na = "x")

# Applied over an example vector
vector <- c(3998098008, -123421421, "c", "x")
pretty_num(vector)
pretty_num(vector, prefix = "+/-", gbp = TRUE)

# Return original values if NA
pretty_num(vector, ignore_na = TRUE)

# Return alternative value in place of NA
pretty_num(vector, alt_na = "z")
}
\seealso{
\code{\link[=comma_sep]{comma_sep()}} \code{\link[=round_five_up]{round_five_up()}} \code{\link[=as.numeric]{as.numeric()}}

Other prettying: 
\code{\link{pretty_filesize}()},
\code{\link{pretty_num_table}()},
\code{\link{pretty_time_taken}()}
}
\concept{prettying}
