% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_container_from_table.R
\name{batch_container_from_table}
\alias{batch_container_from_table}
\title{Creates a \link{BatchContainer} from a table
(\link{data.frame}/\link[tibble:tibble]{tibble::tibble}) containing sample and location information.}
\usage{
batch_container_from_table(tab, location_cols)
}
\arguments{
\item{tab}{A table with location and sample information.
Table rows with all \code{NA}s in sample information columns are treated as empty
locations.}

\item{location_cols}{Names of columns containing information about locations.}
}
\value{
A \link{BatchContainer} assigned samples.
}
\description{
Creates a \link{BatchContainer} from a table
(\link{data.frame}/\link[tibble:tibble]{tibble::tibble}) containing sample and location information.
}
\examples{
tab <- data.frame(
  row = rep(1:3, each = 3),
  column = rep(1:3, 3),
  sample_id = c(1, 2, 3, NA, 5, 6, 7, NA, 9)
)
bc <- batch_container_from_table(tab, location_cols = c("row", "column"))
}
