% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densratio.R
\name{densratio}
\alias{densratio}
\title{Estimate Density Ratio p(x)/q(x)}
\usage{
densratio(x1, x2, method = c("uLSIF", "RuLSIF", "KLIEP"),
  sigma = "auto", lambda = "auto", alpha = 0.1, kernel_num = 100,
  fold = 5, verbose = TRUE)
}
\arguments{
\item{x1}{numeric vector or matrix. Data from a numerator distribution p(x).}

\item{x2}{numeric vector or matrix. Data from a denominator distribution q(x).}

\item{method}{"uLSIF" (default), "RuLSIF", or "KLIEP".}

\item{sigma}{positive numeric vector. Search range of Gaussian kernel bandwidth.}

\item{lambda}{positive numeric vector. Search range of regularization parameter for uLSIF and RuLSIF.}

\item{alpha}{numeric in [0, 1]. Relative parameter for RuLSIF. Default 0.1.}

\item{kernel_num}{positive integer. Number of kernels.}

\item{fold}{positive integer. Numer of the folds of cross validation for KLIEP.}

\item{verbose}{logical (default TRUE).}
}
\value{
densratio object that contains a function to compute estimated density ratio.
}
\description{
Estimate Density Ratio p(x)/q(x)
}
\examples{
x1 <- rnorm(200, mean = 1, sd = 1/8)
x2 <- rnorm(200, mean = 1, sd = 1/2)

densratio_obj <- densratio(x1, x2)

new_x <- seq(0, 2, by = 0.05)
estimated_density_ratio <- densratio_obj$compute_density_ratio(new_x)

plot(new_x, estimated_density_ratio, pch=19)

}
