
<!-- README.md is generated from README.Rmd. Please edit that file -->

# deformula

Integration of One-Dimensional Functions with Double Exponential
Formulas

## Installation

You can install the released version of deformula from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("deformula")
```

## Description

The double exponential formula has been proposed by the following:

-   H. Takahasi and M. Mori, Double Exponential Formulas for Numerical
    Integration, Publications of RIMS, Kyoto University, vol. 9 (1974),
    pg. 721–741.

which is known as the high precision quadrature. The double exponential
formula is also called tanh_sinh, sinh_sinh and exp_sinh quadrature such
as in Boost C++.

This package only implements tanh_sinh for a finite interval \[lower,
upper\] and exp_sinh for
![\[0, \\infty](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;%5B0%2C%20%5Cinfty "[0, \infty").

## Example

The example shows the integral of the function
![y = e^{-a x}](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;y%20%3D%20e%5E%7B-a%20x%7D "y = e^{-a x}")
on
![\[0, \\infty)](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;%5B0%2C%20%5Cinfty%29 "[0, \infty)"):

``` r
library(deformula)
f <- function(x, a) exp(-a*x)
deformula.zeroinf(f, a=0.1)
#> $value
#> [1] 10
#> 
#> $x
#>   [1] 4.770700e-14 1.067180e-13 2.337440e-13 5.015686e-13 1.054974e-12
#>   [6] 2.176216e-12 4.404871e-12 8.752893e-12 1.708313e-11 3.276316e-11
#>  [11] 6.177404e-11 1.145573e-10 2.090378e-10 3.754886e-10 6.642295e-10
#>  [16] 1.157614e-09 1.988399e-09 3.367470e-09 5.625037e-09 9.270984e-09
#>  [21] 1.508198e-08 2.422544e-08 3.843364e-08 6.024472e-08 9.333230e-08
#>  [26] 1.429501e-07 2.165246e-07 3.244349e-07 4.810267e-07 7.059159e-07
#>  [31] 1.025643e-06 1.475754e-06 2.103376e-06 2.970396e-06 4.157302e-06
#>  [36] 5.767822e-06 7.934425e-06 1.082481e-05 1.464944e-05 1.967030e-05
#>  [41] 2.621079e-05 3.466702e-05 4.552037e-05 5.935148e-05 7.685550e-05
#>  [46] 9.885879e-05 1.263367e-04 1.604328e-04 2.024787e-04 2.540148e-04
#>  [51] 3.168123e-04 3.928945e-04 4.845591e-04 5.943999e-04 7.253281e-04
#>  [56] 8.805926e-04 1.063799e-03 1.278930e-03 1.530354e-03 1.822850e-03
#>  [61] 2.161609e-03 2.552247e-03 3.000811e-03 3.513779e-03 4.098061e-03
#>  [66] 4.760997e-03 5.510345e-03 6.354271e-03 7.301340e-03 8.360491e-03
#>  [71] 9.541023e-03 1.085257e-02 1.230506e-02 1.390873e-02 1.567405e-02
#>  [76] 1.761170e-02 1.973257e-02 2.204769e-02 2.456821e-02 2.730538e-02
#>  [81] 3.027050e-02 3.347488e-02 3.692985e-02 4.064670e-02 4.463664e-02
#>  [86] 4.891081e-02 5.348026e-02 5.835589e-02 6.354850e-02 6.906871e-02
#>  [91] 7.492700e-02 8.113371e-02 8.769899e-02 9.463288e-02 1.019452e-01
#>  [96] 1.096459e-01 1.177444e-01 1.262503e-01 1.351732e-01 1.445225e-01
#> [101] 1.543077e-01 1.645383e-01 1.752239e-01 1.863743e-01 1.979994e-01
#> [106] 2.101094e-01 2.227148e-01 2.358263e-01 2.494554e-01 2.636137e-01
#> [111] 2.783136e-01 2.935682e-01 3.093912e-01 3.257973e-01 3.428020e-01
#> [116] 3.604218e-01 3.786745e-01 3.975790e-01 4.171558e-01 4.374266e-01
#> [121] 4.584148e-01 4.801458e-01 5.026466e-01 5.259466e-01 5.500771e-01
#> [126] 5.750722e-01 6.009683e-01 6.278050e-01 6.556248e-01 6.844733e-01
#> [131] 7.144001e-01 7.454585e-01 7.777059e-01 8.112044e-01 8.460208e-01
#> [136] 8.822275e-01 9.199023e-01 9.591295e-01 1.000000e+00 1.042612e+00
#> [141] 1.087072e+00 1.133495e+00 1.182004e+00 1.232735e+00 1.285833e+00
#> [146] 1.341456e+00 1.399776e+00 1.460977e+00 1.525263e+00 1.592851e+00
#> [151] 1.663981e+00 1.738912e+00 1.817927e+00 1.901334e+00 1.989469e+00
#> [156] 2.082701e+00 2.181430e+00 2.286098e+00 2.397186e+00 2.515223e+00
#> [161] 2.640791e+00 2.774527e+00 2.917136e+00 3.069393e+00 3.232154e+00
#> [166] 3.406363e+00 3.593069e+00 3.793430e+00 4.008733e+00 4.240409e+00
#> [171] 4.490048e+00 4.759425e+00 5.050520e+00 5.365547e+00 5.706984e+00
#> [176] 6.077614e+00 6.480560e+00 6.919340e+00 7.397918e+00 7.920774e+00
#> [181] 8.492976e+00 9.120272e+00 9.809187e+00 1.056715e+01 1.140264e+01
#> [186] 1.232533e+01 1.334632e+01 1.447834e+01 1.573601e+01 1.713623e+01
#> [191] 1.869849e+01 2.044538e+01 2.240312e+01 2.460224e+01 2.707836e+01
#> [196] 2.987314e+01 3.303547e+01 3.662282e+01 4.070301e+01 4.535623e+01
#> [201] 5.067764e+01 5.678043e+01 6.379973e+01 7.189728e+01 8.126736e+01
#> [206] 9.214410e+01 1.048106e+02 1.196102e+02 1.369612e+02 1.573745e+02
#> [211] 1.814769e+02 2.100400e+02 2.440178e+02 2.845939e+02 3.332433e+02
#> 
#> $w
#>   [1] 1.465268e-12 3.191921e-12 6.808246e-12 1.422678e-11 2.914070e-11
#>   [6] 5.853875e-11 1.153876e-10 2.232867e-10 4.243901e-10 7.926314e-10
#>  [11] 1.455394e-09 2.628377e-09 4.670696e-09 8.170469e-09 1.407548e-08
#>  [16] 2.388941e-08 3.996169e-08 6.590892e-08 1.072181e-07 1.720969e-07
#>  [21] 2.726540e-07 4.265150e-07 6.589999e-07 1.006020e-06 1.517876e-06
#>  [26] 2.264166e-06 3.340054e-06 4.874155e-06 7.038336e-06 1.005973e-05
#>  [31] 1.423528e-05 1.994911e-05 2.769306e-05 3.809052e-05 5.192391e-05
#>  [36] 7.016584e-05 9.401398e-05 1.249297e-04 1.646799e-04 2.153826e-04
#>  [41] 2.795542e-04 3.601598e-04 4.606641e-04 5.850825e-04 7.380320e-04
#>  [46] 9.247794e-04 1.151287e-03 1.424253e-03 1.751145e-03 2.140231e-03
#>  [51] 2.600595e-03 3.142146e-03 3.775617e-03 4.512553e-03 5.365284e-03
#>  [56] 6.346885e-03 7.471127e-03 8.752410e-03 1.020569e-02 1.184638e-02
#>  [61] 1.369028e-02 1.575342e-02 1.805199e-02 2.060218e-02 2.342008e-02
#>  [66] 2.652155e-02 2.992204e-02 3.363654e-02 3.767938e-02 4.206413e-02
#>  [71] 4.680354e-02 5.190933e-02 5.739221e-02 6.326171e-02 6.952615e-02
#>  [76] 7.619260e-02 8.326681e-02 9.075321e-02 9.865490e-02 1.069736e-01
#>  [81] 1.157099e-01 1.248630e-01 1.344309e-01 1.444105e-01 1.547976e-01
#>  [86] 1.655874e-01 1.767738e-01 1.883503e-01 2.003097e-01 2.126445e-01
#>  [91] 2.253468e-01 2.384084e-01 2.518215e-01 2.655781e-01 2.796707e-01
#>  [96] 2.940923e-01 3.088363e-01 3.238972e-01 3.392703e-01 3.549519e-01
#> [101] 3.709397e-01 3.872326e-01 4.038312e-01 4.207376e-01 4.379558e-01
#> [106] 4.554917e-01 4.733532e-01 4.915504e-01 5.100957e-01 5.290038e-01
#> [111] 5.482920e-01 5.679803e-01 5.880914e-01 6.086510e-01 6.296875e-01
#> [116] 6.512328e-01 6.733219e-01 6.959932e-01 7.192887e-01 7.432543e-01
#> [121] 7.679394e-01 7.933979e-01 8.196876e-01 8.468711e-01 8.750155e-01
#> [126] 9.041931e-01 9.344810e-01 9.659622e-01 9.987255e-01 1.032866e+00
#> [131] 1.068484e+00 1.105689e+00 1.144596e+00 1.185329e+00 1.228020e+00
#> [136] 1.272809e+00 1.319846e+00 1.369291e+00 1.421315e+00 1.476100e+00
#> [141] 1.533839e+00 1.594739e+00 1.659021e+00 1.726918e+00 1.798680e+00
#> [146] 1.874572e+00 1.954877e+00 2.039894e+00 2.129941e+00 2.225354e+00
#> [151] 2.326490e+00 2.433725e+00 2.547456e+00 2.668098e+00 2.796089e+00
#> [156] 2.931884e+00 3.075956e+00 3.228794e+00 3.390901e+00 3.562787e+00
#> [161] 3.744968e+00 3.937957e+00 4.142252e+00 4.358334e+00 4.586643e+00
#> [166] 4.827567e+00 5.081419e+00 5.348413e+00 5.628629e+00 5.921977e+00
#> [171] 6.228155e+00 6.546592e+00 6.876386e+00 7.216235e+00 7.564355e+00
#> [176] 7.918383e+00 8.275280e+00 8.631221e+00 8.981479e+00 9.320316e+00
#> [181] 9.640876e+00 9.935109e+00 1.019372e+01 1.040621e+01 1.056093e+01
#> [186] 1.064535e+01 1.064646e+01 1.055128e+01 1.034773e+01 1.002569e+01
#> [191] 9.578301e+00 9.003476e+00 8.305480e+00 7.496377e+00 6.597043e+00
#> [196] 5.637353e+00 4.655154e+00 3.693664e+00 2.797239e+00 2.005845e+00
#> [201] 1.349149e+00 8.416512e-01 4.804847e-01 2.470079e-01 1.121561e-01
#> [206] 4.394246e-02 1.444236e-02 3.847749e-03 7.970180e-04 1.219748e-04
#> [211] 1.295488e-05 8.840707e-07 3.524114e-08 7.290548e-10 6.754708e-12
#> 
#> $t
#>   [1] -3.665625e+00 -3.639063e+00 -3.612500e+00 -3.585938e+00 -3.559375e+00
#>   [6] -3.532813e+00 -3.506250e+00 -3.479688e+00 -3.453125e+00 -3.426563e+00
#>  [11] -3.400000e+00 -3.373438e+00 -3.346875e+00 -3.320313e+00 -3.293750e+00
#>  [16] -3.267188e+00 -3.240625e+00 -3.214063e+00 -3.187500e+00 -3.160938e+00
#>  [21] -3.134375e+00 -3.107813e+00 -3.081250e+00 -3.054688e+00 -3.028125e+00
#>  [26] -3.001563e+00 -2.975000e+00 -2.948438e+00 -2.921875e+00 -2.895313e+00
#>  [31] -2.868750e+00 -2.842188e+00 -2.815625e+00 -2.789063e+00 -2.762500e+00
#>  [36] -2.735938e+00 -2.709375e+00 -2.682813e+00 -2.656250e+00 -2.629688e+00
#>  [41] -2.603125e+00 -2.576563e+00 -2.550000e+00 -2.523438e+00 -2.496875e+00
#>  [46] -2.470313e+00 -2.443750e+00 -2.417188e+00 -2.390625e+00 -2.364063e+00
#>  [51] -2.337500e+00 -2.310938e+00 -2.284375e+00 -2.257813e+00 -2.231250e+00
#>  [56] -2.204688e+00 -2.178125e+00 -2.151563e+00 -2.125000e+00 -2.098438e+00
#>  [61] -2.071875e+00 -2.045313e+00 -2.018750e+00 -1.992188e+00 -1.965625e+00
#>  [66] -1.939063e+00 -1.912500e+00 -1.885938e+00 -1.859375e+00 -1.832813e+00
#>  [71] -1.806250e+00 -1.779688e+00 -1.753125e+00 -1.726563e+00 -1.700000e+00
#>  [76] -1.673438e+00 -1.646875e+00 -1.620313e+00 -1.593750e+00 -1.567188e+00
#>  [81] -1.540625e+00 -1.514063e+00 -1.487500e+00 -1.460938e+00 -1.434375e+00
#>  [86] -1.407813e+00 -1.381250e+00 -1.354688e+00 -1.328125e+00 -1.301563e+00
#>  [91] -1.275000e+00 -1.248438e+00 -1.221875e+00 -1.195313e+00 -1.168750e+00
#>  [96] -1.142188e+00 -1.115625e+00 -1.089063e+00 -1.062500e+00 -1.035938e+00
#> [101] -1.009375e+00 -9.828125e-01 -9.562500e-01 -9.296875e-01 -9.031250e-01
#> [106] -8.765625e-01 -8.500000e-01 -8.234375e-01 -7.968750e-01 -7.703125e-01
#> [111] -7.437500e-01 -7.171875e-01 -6.906250e-01 -6.640625e-01 -6.375000e-01
#> [116] -6.109375e-01 -5.843750e-01 -5.578125e-01 -5.312500e-01 -5.046875e-01
#> [121] -4.781250e-01 -4.515625e-01 -4.250000e-01 -3.984375e-01 -3.718750e-01
#> [126] -3.453125e-01 -3.187500e-01 -2.921875e-01 -2.656250e-01 -2.390625e-01
#> [131] -2.125000e-01 -1.859375e-01 -1.593750e-01 -1.328125e-01 -1.062500e-01
#> [136] -7.968750e-02 -5.312500e-02 -2.656250e-02  4.440892e-16  2.656250e-02
#> [141]  5.312500e-02  7.968750e-02  1.062500e-01  1.328125e-01  1.593750e-01
#> [146]  1.859375e-01  2.125000e-01  2.390625e-01  2.656250e-01  2.921875e-01
#> [151]  3.187500e-01  3.453125e-01  3.718750e-01  3.984375e-01  4.250000e-01
#> [156]  4.515625e-01  4.781250e-01  5.046875e-01  5.312500e-01  5.578125e-01
#> [161]  5.843750e-01  6.109375e-01  6.375000e-01  6.640625e-01  6.906250e-01
#> [166]  7.171875e-01  7.437500e-01  7.703125e-01  7.968750e-01  8.234375e-01
#> [171]  8.500000e-01  8.765625e-01  9.031250e-01  9.296875e-01  9.562500e-01
#> [176]  9.828125e-01  1.009375e+00  1.035937e+00  1.062500e+00  1.089062e+00
#> [181]  1.115625e+00  1.142187e+00  1.168750e+00  1.195312e+00  1.221875e+00
#> [186]  1.248437e+00  1.275000e+00  1.301562e+00  1.328125e+00  1.354687e+00
#> [191]  1.381250e+00  1.407812e+00  1.434375e+00  1.460937e+00  1.487500e+00
#> [196]  1.514062e+00  1.540625e+00  1.567187e+00  1.593750e+00  1.620312e+00
#> [201]  1.646875e+00  1.673437e+00  1.700000e+00  1.726562e+00  1.753125e+00
#> [206]  1.779687e+00  1.806250e+00  1.832812e+00  1.859375e+00  1.885937e+00
#> [211]  1.912500e+00  1.939062e+00  1.965625e+00  1.992187e+00  2.018750e+00
#> 
#> $h
#> [1] 0.0265625
#> 
#> $message
#> [1] "OK"
```

The example shows the integral of the function
![y = e^{-a x}](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;y%20%3D%20e%5E%7B-a%20x%7D "y = e^{-a x}")
on
![\[0, 1\]](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;%5B0%2C%201%5D "[0, 1]"):

``` r
f <- function(x, a) exp(-a*x)
deformula.moneone(f, 0, 1, a=0.1)
#> $value
#> [1] 0.9516258
#> 
#> $x
#>  [1] 4.803047e-12 4.286475e-10 1.788046e-08 3.976314e-07 5.258993e-06
#>  [6] 4.530765e-05 2.742828e-04 1.242572e-03 4.436504e-03 1.301657e-02
#> [11] 3.241957e-02 7.021547e-02 1.344910e-01 2.304266e-01 3.560600e-01
#> [16] 5.000000e-01 6.439400e-01 7.695734e-01 8.655090e-01 9.297845e-01
#> [21] 9.675804e-01 9.869834e-01 9.955635e-01 9.987574e-01 9.997257e-01
#> [26] 9.999547e-01 9.999947e-01 9.999996e-01 1.000000e+00 1.000000e+00
#> [31] 1.000000e+00
#> 
#> $w
#>  [1] 1.260817e-10 9.343641e-09 3.238878e-07 5.991850e-06 6.602614e-05
#>  [6] 4.749713e-04 2.408083e-03 9.170444e-03 2.763258e-02 6.862167e-02
#> [11] 1.446506e-01 2.636812e-01 4.194077e-01 5.831384e-01 7.073669e-01
#> [16] 7.470938e-01 6.872936e-01 5.525312e-01 3.898420e-01 2.419627e-01
#> [21] 1.317367e-01 6.225331e-02 2.502519e-02 8.299823e-03 2.179043e-03
#> [26] 4.297757e-04 5.974298e-05 5.421651e-06 2.930658e-07 8.454476e-09
#> [31] 1.140835e-10
#> 
#> $t
#>  [1] -2.8125 -2.6250 -2.4375 -2.2500 -2.0625 -1.8750 -1.6875 -1.5000 -1.3125
#> [10] -1.1250 -0.9375 -0.7500 -0.5625 -0.3750 -0.1875  0.0000  0.1875  0.3750
#> [19]  0.5625  0.7500  0.9375  1.1250  1.3125  1.5000  1.6875  1.8750  2.0625
#> [28]  2.2500  2.4375  2.6250  2.8125
#> 
#> $h
#> [1] 0.1875
#> 
#> $message
#> [1] "OK"
```
