% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetra-column.R
\name{tetra-column}
\alias{tetra-column}
\alias{deb_gather_tetra}
\alias{deb_spread_tetra}
\title{Helpers to create and separate a \code{deb_tetra} column in a data frame}
\usage{
deb_gather_tetra(
  df,
  l = l,
  s = s,
  d = d,
  f = f,
  bases = c(20, 12, 4),
  tetra_col = tetra,
  replace = FALSE
)

deb_spread_tetra(
  df,
  tetra = tetra,
  l_col = l,
  s_col = s,
  d_col = d,
  f_col = f,
  replace = FALSE
)
}
\arguments{
\item{df}{A data frame.}

\item{l}{Pounds column: Unquoted name of a numeric variable corresponding
to the pounds or libra unit. Default is \code{l}.}

\item{s}{Shillings column: Unquoted name of numeric variable corresponding
to the shillings or solidus unit. Default is \code{s}.}

\item{d}{Pence column: Unquoted name of numeric variable corresponding to
the pence or denarius unit. Default is \code{d}.}

\item{f}{Farthing column: Unquoted name of numeric variable corresponding
to the farthing or f unit. Default is \code{f}.}

\item{bases}{Numeric vector of length 3 used to specify the bases for the
solidus or s, denarius or d, and farthing or f units. Default is
\code{c(20, 12, 4)}, which conforms to the English system of 1 pound =
20 shillings, 1 shilling = 12 pence, and 1 pence = 4 farthing.}

\item{tetra_col}{Unquoted name of the \code{deb_tetra} column created by the
function. Default is \code{tetra}.}

\item{replace}{Logical (default \code{FALSE}). When \code{TRUE}, the newly created
column(s) will replace the one(s) used to create it/them.}

\item{tetra}{\code{deb_tetra} column: Unquoted name of a \code{deb_tetra} column.
Default is \code{tetra}.}

\item{l_col}{An unquoted name for the pounds column created by the
function. Default is \code{l}.}

\item{s_col}{An unquoted name for the shillings column created by the
function. Default is \code{s}.}

\item{d_col}{An unquoted name for the pence column created by the
function. Default is \code{d}.}

\item{f_col}{An unquoted name for the farthings column created by the
function. Default is \code{f}.}
}
\value{
A data frame with a new \code{deb_tetra} column for \code{deb_gather_tetra()}
or new pounds, shillings, pence, and farthing columns for
\code{deb_spread_tetra()}.
}
\description{
\itemize{
\item \code{deb_gather_tetra()} creates a \code{deb_tetra} column from separate
variables representing pounds, shillings, pence, and farthing values.
\item \code{deb_spread_tetra()} creates separate variables for pounds, shillings,
pence, and farthings from a \code{deb_tetra} column.
}
}
\details{
When transcribing historical accounting data by hand, entering the pounds,
shillings, pence, and optionally farthing values (lsd(f)) into separate
columns is probably the easiest and least error prone method. The
\code{deb_gather_()} and \code{deb_spread_()} set of functions provide helpers to
go back and forth between this mode of data entry and the use of \code{deb_lsd}
and \code{deb_tetra} vectors within data frames in R. \code{deb_gather_tetra()}
creates a \code{deb_tetra} column from four separate columns representing the
four units in this type of value. \code{deb_spread_tetra()} does the opposite.
It takes a \code{deb_tetra} column and spreads it into four separate columns
representing the four units.

Values for column names (\code{tetra_col}, \code{l_col}, \code{s_col}, \code{d_col}, and
\code{f_col}) must be valid column names. They can be quoted or unquoted, but
they cannot be vectors or bare numbers. This follows the rules of
\code{\link[dplyr:rename]{dplyr::rename()}}.
}
\examples{

libra <- c(3, 5, 6, 2)
solidus <- c(10, 18, 11, 16)
denarius <- c(9, 11, 10, 5)
farthing <- c(2, 3, 1, 0)

# data frame with separate l, s, and d variables and default names
x <- data.frame(accounts = c(1, 2, 3, 4),
                l = libra,
                s = solidus,
                d = denarius,
                f = farthing)

# data frame with deb_tetra variable and default names
y <- data.frame(accounts = c(1, 2, 3, 4),
                tetra = deb_tetra(l = libra,
                                  s = solidus,
                                  d = denarius,
                                  f = farthing))

# Gather l, s, d, and f variables into a deb_tetra column
deb_gather_tetra(x, l = l, s = s, d = d, f = f)

# Spread deb_tetra column into separate l, s, d, and f columns
deb_spread_tetra(y, tetra = tetra)

# Replace original columns with replace = TRUE
deb_gather_tetra(x, replace = TRUE)
deb_spread_tetra(y, replace = TRUE)

# Choose non-default column names
deb_gather_tetra(x, tetra_col = data, replace = TRUE)
deb_spread_tetra(y,
                 l_col = libra,
                 s_col = solidus,
                 d_col = denarius,
                 f_col = farthing,
                 replace = TRUE)

# The two functions are opposites
z <- x \%>\%
  deb_gather_tetra(replace = TRUE) \%>\%
  deb_spread_tetra(replace = TRUE)
all.equal(x, z)

}
\seealso{
\code{\link[=deb_gather_lsd]{deb_gather_lsd()}} and \code{\link[=deb_spread_lsd]{deb_spread_lsd()}} provide the same
functionality for the more common tripartite values of pounds, shillings,
and pence.
}
