% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/river_net.R
\name{river_net}
\alias{river_net}
\title{Create a \code{river_net} Object}
\usage{
river_net(
  rivers,
  barriers,
  outlet,
  check = TRUE,
  tolerance = NULL,
  max_iter = 10
)
}
\arguments{
\item{rivers}{A \code{rivers} object returned by \code{\link[=import_rivers]{import_rivers()}}.}

\item{barriers}{A \code{barriers} object returned by \code{\link[=import_points]{import_points()}} with
\code{type = "bars"}.}

\item{outlet}{An \code{outlet} object returned by \code{\link[=import_points]{import_points()}} with
\code{type = "out"}.}

\item{check}{Logical. If \code{TRUE} (default), dendritic topology is enforced
using \code{\link[=enforce_dendritic]{enforce_dendritic()}}.}

\item{tolerance}{A numeric value specifying the snapping distance
(in map units) to align points to the river network. Defaults to \code{NULL},
meaning no snapping.}

\item{max_iter}{An integer indicating the maximum number of correction
iterations to run. As some topological errors are corrected new ones can
can arise requiring multiple passes. In some cases, an automated correction
choice can lead to a recursive correction that eliminates most rivers. In
this case, some manual corrections may help avoid this.}
}
\value{
An object of class \link{river_net} representing the river network formed
from the provided spatial inputs.
}
\description{
Constructs a \link{river_net} object, a geospatial network structure built on top
of the \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork()}} class. This object integrates river lines,
barriers and outlets allowing for connectivity analyses with
\code{\link[=calculate_dci]{calculate_dci()}} or other network tools.
}
\examples{
riv_in <- import_rivers(yamaska_rivers, quiet = TRUE)
bar_in <- import_points(yamaska_barriers, type = "bars")
out_in <- import_points(yamaska_outlet, type = "out")

# For large river networks it may be better to specify a smaller number of
# correction sweeps.
yam_net <- river_net(rivers = riv_in, barriers = bar_in,
outlet = out_in, max_iter = 3)
}
