% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_natpsoho.R
\name{natParticle}
\alias{natParticle}
\title{R6 class that defines a Particle in the PSO algorithm}
\arguments{
\item{nodes}{a vector with the names of the nodes}

\item{ordering}{a vector with the names of the nodes in t_0}

\item{ordering_raw}{a vector with the names of the nodes without the appended "_t_0"}

\item{max_size}{maximum number of timeslices of the DBN}

\item{v_probs}{vector of probabilities for the velocity sampling}

\item{p}{parameter of the truncated geometric distribution}

\item{score}{bnlearn score function used}

\item{dt}{dataset to evaluate the fitness of the particle}

\item{in_cte}{parameter that varies the effect of the inertia}

\item{gb_cte}{parameter that varies the effect of the global best}

\item{gb_ps}{position of the global best}

\item{lb_cte}{parameter that varies the effect of the local best}

\item{r_probs}{vector that defines the range of random variation of gb_cte and lb_cte}
}
\value{
A new 'natParticle' object

The score of the current position
}
\description{
Constructor of the 'natParticle' class

Evaluate the score of the particle's position

Evaluate the score of the particle's position.
Updates the local best if the new one is better.

Update the position of the particle with the velocity

Update the position of the particle given the constants after calculating
the new velocity
}
\details{
A particle has a Position, a Velocity and a local best
}
\section{Fields}{

\describe{
\item{\code{ps}}{position of the particle}

\item{\code{cl}}{velocity of the particle}

\item{\code{velocity}}{that takes the particle to the global best}

\item{\code{velocity}}{that takes the particle to the local best}

\item{\code{lb}}{local best score obtained}

\item{\code{lb_ps}}{local best position found}

\item{\code{score}}{bnlearn score function used}
}}

\keyword{internal}
