% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seas_utils.R
\name{seas_df_long}
\alias{seas_df_long}
\title{Seasonally adjust long format data using seas()}
\usage{
seas_df_long(
  df,
  sa_names,
  x11 = FALSE,
  transfunc = "none",
  series_names = "series_name",
  value_var = "value",
  date_var = "ref_date"
)
}
\arguments{
\item{df}{long format dataframe}

\item{sa_names}{names of series to seasonally adjust}

\item{x11}{T/F, use x11 as opposed to X-13 SEATS}

\item{transfunc}{Data transformation, one of `none` for no transformation, `auto` for automatic detection, or `log` for log transformation}

\item{series_names}{name of column containing series names}

\item{value_var}{name of column containing values}

\item{date_var}{name of column containing dates}
}
\value{
A list with data.frames `sa_factors` containing seasonal factors and `values_sa` containing seasonally adjusted data.
}
\description{
Seasonaly adjust multiple monthly or quarterly series in long format using X-13 SEATS via seas()
}
\examples{
seas_df_long(fred[series_name == "gdp constant prices"], sa_names="value")
}
