% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_wide}
\alias{process_wide}
\title{Process Wide Format Data}
\usage{
process_wide(
  dt_wide,
  lib,
  detrend = TRUE,
  center = TRUE,
  scale = TRUE,
  date_name = "ref_date",
  ignore_numeric_names = TRUE,
  silent = FALSE
)
}
\arguments{
\item{dt_wide}{Data in wide format.}

\item{lib}{Library with instructions regarding how to process data; see details.}

\item{detrend}{T/F should data be detrended (see details)?}

\item{center}{T/F should data be centered (i.e. de-meaned)?}

\item{scale}{T/F should data be scaled (i.e. variance 1)?}

\item{date_name}{Name of data column in the data.}

\item{ignore_numeric_names}{T/F ignore numeric values in matching series names in `dt` to series names in `lib`. This
is required for data aggregated using `process_MF()`, as lags of LHS and RHS data are tagged 0 for contemporaneous data, 
1 for one lag, 2 for 2 lags, etc. Ignoring these tags insures processing from `lib` is correctly identified.}

\item{silent}{T/F, supress warnings?}
}
\value{
data.table of processed data
}
\description{
Process data in wide format for time series modeling
}
\details{
`process_wide()` can be used to transform wide data to insure stationarity. Censoring by pub_date requires long format. Directions
for processing each file come from the data.table `lib`. This table must include the columns `series_name`, `take_logs`,
and `take_diffs`. Unique series may also be identified by a combination of `country` and `series_name`. Optional columns
include `needs_SA` for series that need seasonal adjustment, `detrend` for removing low frequency trends (nowcasting only;
`detrend` should not be used for long horizon forecasts), `center` to de-mean the data, and `scale` to scale the data. If the 
argument to `process_wide()` of `detrend`, `center`, or `scale` is `FALSE`, the operation will not be performed. If `TRUE`,
the function will check for the column of the same name in `lib`. If the column exists, T/F entries from this column are used
to determine which series to transform. If the column does not exist, all series will be transformed.
}
\examples{
LHS <- fred[series_name == "gdp constant prices"]
RHS <- fred[series_name != "gdp constant prices"]
dtQ <- process_MF(LHS, RHS)
dt_wide <- data.table::dcast(dtQ, ref_date ~ series_name, value.var = "value")
dt_processed <- process_wide(dt_wide, fredlib)
}
