% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_utils.R
\name{pct_response}
\alias{pct_response}
\title{Percent of responses at a given frequency}
\usage{
pct_response(
  dt,
  col_name = NULL,
  by = c("month", "quarter", "week"),
  date_name = "ref_date"
)
}
\arguments{
\item{dt}{data table of responses}

\item{col_name}{name of column containing responses}

\item{by}{frequency of response aggregation, one of `"month"`, `"quarter"`, `"week"`}

\item{date_name}{name of column containing dates}
}
\value{
The percent of responses at the frequency
}
\description{
Return the percent of responses to categorical answers at a specified frequency
}
\examples{
dt <- data.frame("ref_date" = seq.Date(as.Date("2000-01-01"), length.out = 100, by = "week"),
                 "response" = c(rep("yes", 20), rep("no",50),rep("yes",30)))
out <- pct_response(dt, col_name = "response")
}
