% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_forecast_dates}
\alias{add_forecast_dates}
\title{Add NA values to the tail of a wide data.table}
\usage{
add_forecast_dates(
  dt,
  horizon = 1,
  frq = c("month", "week", "quarter", "year"),
  date_name = "ref_date"
)
}
\arguments{
\item{dt}{data.table in wide format}

\item{horizon}{number of periods to add at specified `frq`}

\item{frq}{frequency for aggregation, one of `"month"`, `"week"`, `"quarter"`, or `"year"`}

\item{date_name}{name of date column}
}
\value{
NA-filled data.table in wide format
}
\description{
Add NA values to the tail of a wide data.table to be filled by forecasting routines
}
\examples{
add_forecast_dates(fred[series_name == "gdp constant prices"],frq="quarter")
}
