% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam.R
\name{load_pam}
\alias{load_pam}
\title{PAM - Municipal Agricultural Production}
\usage{
load_pam(dataset, raw_data = FALSE, geo_level, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("all_crops", "permanent_crops", "temporary_crops" or many individual crop possibilities (see \code{vignette(load_pam)})). You can also use SIDRA codes (see \url{https://sidra.ibge.gov.br/pesquisa/pam/tabelas})}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble} consisting of geographic units that present positive values for any of the variables in the dataset.
}
\description{
Loads information on the quantity, value and area of temporary and permanent crops cultivated.
}
\examples{
\dontrun{
# download treated data at the state level from 2010 to 2011 for all crops
data <- load_pam(
  dataset = "all_crops",
  raw_data = FALSE,
  geo_level = "state",
  time_period = 2010:2011,
  language = "eng"
)
}

}
