% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbiomas.R
\name{load_mapbiomas}
\alias{load_mapbiomas}
\title{MAPBIOMAS - The Annual Land Cover and Use Mapping Project in Brazil}
\usage{
load_mapbiomas(
  dataset,
  raw_data = FALSE,
  geo_level = "municipality",
  language = "eng"
)
}
\arguments{
\item{dataset}{A dataset name ("mapbiomas_cover", "mapbiomas_transition", "mapbiomas_irrigation", "mapbiomas_deforestation_regeneration", "mapbiomas_mining", "mapbiomas_water" or "mapbiomas_fire")}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data
\itemize{
\item For dataset "mapbiomas_cover", can be "municipality" or "state" (faster download)
\item For dataset "mapbiomas_transition", can be "municipality" or "state" (faster download)
\item For dataset "mapbiomas_deforestation_regeneration", can only be "municipality"
\item For dataset "mapbiomas_mining", can be "indigenous_land" or "municipality"
\item For dataset "mapbiomas_irrigation", can be "state" or "biome"
\item For dataset "mapbiomas_water", can be "municipality", "state" or "biome"
\item For dataset "mapbiomas_fire", can only be "state"
}}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads information about land cover and use
}
\examples{
\dontrun{
# download treated Mapbiomas Cover data in English
data <- load_mapbiomas(
  dataset = "mapbiomas_cover",
  raw_data = FALSE,
  geo_level = "municipality",
  language = "eng"
)

# download treated data on mining on indigenous lands
data <- load_mapbiomas("mapbiomas_mining",
  raw_data = FALSE,
  geo_level = "indigenous_land"
)
}

}
