% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_list_voc.R
\name{prep_list_voc}
\alias{prep_list_voc}
\title{All valid \verb{voc:} vocabularies}
\usage{
prep_list_voc()
}
\value{
\code{\link[=character]{character()}} all \verb{voc:} suffixes allowed for
\code{\link[=prep_get_data_frame]{prep_get_data_frame()}}.
}
\description{
All valid \verb{voc:} vocabularies
}
\examples{
\dontrun{
prep_list_dataframes()
prep_list_voc()
prep_get_data_frame("<ICD10>")
my_voc <-
  tibble::tribble(
    ~ voc, ~ url,
    "test", "data:datasets|iris|Species+Sepal.Length")
prep_add_data_frames(`<>` = my_voc)
prep_list_dataframes()
prep_list_voc()
prep_get_data_frame("<test>")
prep_get_data_frame("<ICD10>")
my_voc <-
  tibble::tribble(
    ~ voc, ~ url,
    "ICD10", "data:datasets|iris|Species+Sepal.Length")
prep_add_data_frames(`<>` = my_voc)
prep_list_dataframes()
prep_list_voc()
prep_get_data_frame("<ICD10>")
}

}
