% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddr.R
\name{ddr}
\alias{ddr}
\title{Get DDR data}
\usage{
ddr(date, asset_class, show_col_types = FALSE)
}
\arguments{
\item{date}{the date for which data is required as Date or DateTime object.
Only the year, month and day elements of the object are used and it must of
be length one.}

\item{asset_class}{the asset class for which you would like to download trade
data. Valid inputs are \code{"CR"} (credit), \code{"IR"} (rates),
\code{"EQ"} (equities), \code{"FX"} (foreign exchange), \code{"CO"}
(commodities). This must be a string.}

\item{show_col_types}{if \code{FALSE} (default), do not show the guessed column
types. If \code{TRUE} always show the column types, even if they are supplied.
If \code{NULL} only show the column types if they are not explicitly supplied by
the col_types argument.}
}
\value{
a tibble that contains the requested data. If no data exists
on that date, an empty tibble is returned.
}
\description{
The DTCC Data Repository is a registered U.S. swap data repository that
allows market participants to fulfil their public disclosure obligations
under U.S. legislation. This function will give you the ability to download
trade-level data that is reported by market participants. Column specs are
inferred from all records in the file (i.e. \code{guess_max} is set to \code{Inf}
when calling \link[readr:read_delim]{readr::read_csv}).
}
\examples{
\dontrun{
ddr(as.Date("2017-05-25"), "IR") # Not empty
ddr(as.Date("2020-12-01"), "CR") # Not empty
}
}
\references{
\href{https://pddata.dtcc.com/gtr/}{DDR Real Time Dissemination Platform}
}
