% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sample.r
\name{gl.sample}
\alias{gl.sample}
\title{Samples individuals from populations}
\usage{
gl.sample(
  x,
  nsample = min(table(pop(x))),
  replace = TRUE,
  onepop = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{genlight object containing SNP/silicodart genotypes}

\item{nsample}{the number of individuals that should be sampled}

\item{replace}{a switch to sample by replacement (default).}

\item{onepop}{switch to ignore population settings of the genlight object and sample from all individuals disregarding the population definition. [default FALSE].}

\item{verbose}{set verbosity}
}
\value{
returns a genlight object with nsample samples from each populations.
}
\description{
This is a convenience function to prepare a bootstrap approach in dartR. For a bootstrap approach it is often desirable to sample a defined number of individuals for each of the populations in a genlight object and then calculate a certain quantity for that subset (redo a 1000 times)
}
\details{
This is convenience function to facilitate a bootstrap approach
}
\examples{
\dontrun{
#bootstrap for 2 possums populations to check effect of sample size on fixed alleles
gl.set.verbosity(0)
pp <- possums.gl[1:60,]
nrep <- 1:10
nss <- seq(1,10,2)
res <- expand.grid(nrep=nrep, nss=nss)
for (i in 1:nrow(res)) {
dummy <- gl.sample(pp, nsample=res$nss[i], replace=TRUE)
pas <- gl.report.pa(dummy, plot.out = F)
res$fixed[i] <- pas$fixed[1]
}
boxplot(fixed ~ nss, data=res)
}
}
\seealso{
Other base dartR: 
\code{\link{gl.sort}()}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{base dartR}
